/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.voidvanguards_common_neoforge.registry.item;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.voidvanguards_common_neoforge.data.ServerSaveData;
import com.natamus.voidvanguards_common_neoforge.parts.cosmos.functions.CosmosDimensionFunctions;
import com.natamus.voidvanguards_common_neoforge.util.SaveLoadUtils;
import com.natamus.voidvanguards_common_neoforge.util.Util;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class OrbitalTransponderItem
extends Item {
    public OrbitalTransponderItem(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int n) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            int useDuration = this.getUseDuration(itemStack, livingEntity) - n;
            if (useDuration >= 25 && !level.isClientSide) {
                UUID playerUUID = serverPlayer.getUUID();
                if (ServerSaveData.get().voidVanguardsCompletedPlayerUUIDS.contains(playerUUID)) {
                    MinecraftServer minecraftServer = level.getServer();
                    if (!Util.isInCosmosDimension(serverPlayer)) {
                        ServerSaveData.get().originalPlayerPositions.put(playerUUID, (Pair<ResourceKey<Level>, BlockPos>)Pair.of((Object)serverPlayer.serverLevel().dimension(), (Object)serverPlayer.blockPosition()));
                        SaveLoadUtils.savePlayerData((Player)serverPlayer);
                        CosmosDimensionFunctions.teleportPlayerToVanguardStation((ServerLevel)level, serverPlayer, false);
                    } else {
                        Pair<ResourceKey<Level>, BlockPos> originalPositionPair = ServerSaveData.get().originalPlayerPositions.get(playerUUID);
                        Services.TELEPORT.teleportEntity((Entity)serverPlayer, (ResourceKey)originalPositionPair.getFirst(), (BlockPos)originalPositionPair.getSecond());
                        MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"item.voidvanguards.orbital_transponder.leaveStation").withStyle(ChatFormatting.DARK_GREEN));
                    }
                } else {
                    MessageFunctions.sendMessage((Player)serverPlayer, (MutableComponent)Component.translatable((String)"item.voidvanguards.orbital_transponder.useUnable").withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    public int getUseDuration(@NotNull ItemStack itemStack, @NotNull LivingEntity livingEntity) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack itemStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }
}

