/*
 * Decompiled with CFR 0.152.
 */
package com.etema.nomorejumpcrit.event;

import com.etema.nomorejumpcrit.util.CritCalculator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nomorejumpcrit")
public class CombatEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (CombatEventHandler.isVanillaCriticalHit(player)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        if (!source.m_276093_(DamageTypes.f_268464_)) {
            return;
        }
        LivingEntity target = event.getEntity();
        float originalDamage = event.getAmount();
        boolean shouldCrit = CritCalculator.shouldCriticalHit(player);
        if (shouldCrit && !CombatEventHandler.isVanillaCriticalHit(player)) {
            float critMultiplier = CritCalculator.getCriticalDamage(player);
            float newDamage = originalDamage * critMultiplier;
            event.setAmount(newDamage);
            CombatEventHandler.spawnCustomCritParticles(target);
            player.m_5496_(SoundEvents.f_12313_, 1.0f, 1.0f);
        }
    }

    private static boolean isVanillaCriticalHit(Player player) {
        return player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_();
    }

    private static void spawnCustomCritParticles(LivingEntity target) {
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 15; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20208_(1.0), target.m_20187_(), target.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 8; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, target.m_20208_(1.0), target.m_20187_(), target.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

