/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.shulkerfix.carpet;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.kikugie.shulkerfix.ShulkerFixMod;
import dev.kikugie.shulkerfix.carpet.ShulkerFixSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class ShulkerFixExtension
implements CarpetExtension {
    public static final ShulkerFixExtension INSTANCE = new ShulkerFixExtension();

    public static void init() {
        CarpetServer.manageExtension((CarpetExtension)INSTANCE);
    }

    public String version() {
        Optional container = FabricLoader.getInstance().getModContainer("shulkerfix");
        return container.isPresent() ? ((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString() : "undefined";
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(ShulkerFixSettings.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> canHasTranslations(String lang) {
        try (InputStream stream = ShulkerFixSettings.class.getClassLoader().getResourceAsStream("assets/shulkerfix/lang/%s.json".formatted(lang));){
            if (stream == null) {
                Map<String, String> map2 = Collections.emptyMap();
                return map2;
            }
            Gson gson = new Gson();
            TypeToken<Map<String, String>> token = new TypeToken<Map<String, String>>(this){};
            InputStreamReader reader = new InputStreamReader(stream);
            Map map = (Map)gson.fromJson((Reader)reader, token.getType());
            return map;
        }
        catch (IOException e) {
            ShulkerFixMod.LOGGER.error("Failed to decode mod language file %s.json".formatted(lang), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

