package dev.kikugie.shulkerfix;


import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2480;
import net.minecraft.class_2614;
import dev.kikugie.shulkerfix.carpet.ShulkerFixSettings;

import static net.minecraft.class_9334.field_50071;

public class Util {
    public static boolean isHopperStackingPrevented(class_1799 stack) {
        return !ShulkerFixSettings.hopperShulkerStacking && isShulkerBox(stack);
    }

    public static boolean isOverstackedOutputAllowed(class_1799 stack) {
        return !Objects.equals(ShulkerFixSettings.overstackedShulkerSignalStrength, "false") && isShulkerBox(stack);
    }

    public static int determineSignalStrengthContribution(class_1799 stack) {
        if (!isShulkerBox(stack)) return stack.method_7914();
        return switch (ShulkerFixSettings.overstackedShulkerSignalStrength) {
            case "true", "capped" -> 1;
            case "normalized" -> stack.method_7947();
            case "false" -> stack.method_7914();
            default -> throw new UnsupportedOperationException(
                "Invalid 'overstackedShulkerSignalStrength' state: " + ShulkerFixSettings.overstackedShulkerSignalStrength);
        };
    }

    public static int limitComparatorOutput(int original) {
        return Objects.equals(ShulkerFixSettings.overstackedShulkerSignalStrength, "capped") ? Math.min(original, 15) : original;
    }

    public static boolean isShulkerBox(class_1799 stack) {
        return stack.method_7909() instanceof class_1747 blockItem && blockItem.method_7711() instanceof class_2480;
    }

    public static boolean hasCustomMaxStackSize(class_1799 stack) {
        int defaultStackSize = stack.method_58658().method_58695(field_50071, 1);
        int currentStackSize = stack.method_58695(field_50071, 1);
        return defaultStackSize != currentStackSize;
    }

    public static class_1263 wrapInventory(class_1263 inventory) {
        return new WrapperInventory(inventory);
    }

    public static boolean isWrapped(class_1263 inventory) {
        return inventory instanceof WrapperInventory;
    }

    public static boolean collectOneItem(class_1263 inventory, class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983().method_46651(1);
        class_1799 itemStack2 = class_2614.method_11260(null, inventory, itemStack, null);
        if (itemStack2.method_7960()) {
            itemEntity.method_6983().method_7934(1);
            if (itemEntity.method_6983().method_7960()) {
                itemEntity.method_6979(class_1799.field_8037);
                itemEntity.method_31472();
            }
            return true;
        }
        return false;
    }

    private record WrapperInventory(class_1263 delegate) implements class_1263 {
        @Override
        public int method_5439() {
            return this.delegate.method_5439();
        }

        @Override
        public boolean method_5442() {
            return this.delegate.method_5442();
        }

        @Override
        public class_1799 method_5438(int slot) {
            return this.delegate.method_5438(slot);
        }

        @Override
        public class_1799 method_5434(int slot, int amount) {
            return this.delegate.method_5434(slot, amount);
        }

        @Override
        public class_1799 method_5441(int slot) {
            return this.delegate.method_5441(slot);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            this.delegate.method_5447(slot, stack);
        }

        @Override
        public void method_5431() {
            this.delegate.method_5431();
        }

        @Override
        public boolean method_5443(class_1657 player) {
            return this.delegate.method_5443(player);
        }

        @Override
        public void method_5448() {
            this.delegate.method_5448();
        }
    }
}