package dev.kikugie.shulkerfix.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.kikugie.shulkerfix.Util;
import dev.kikugie.shulkerfix.carpet.ShulkerFixSettings;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1700;
import net.minecraft.class_1799;
import net.minecraft.class_2614;

@Debug(export = true)
@Mixin(class_2614.class)
public class HopperBlockEntityMixin {
	@WrapOperation(
		method = "inventoryFull",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I")
	)
	private int modifyShulkerMaxCount(class_1799 instance, Operation<Integer> original) {
		return Util.isHopperStackingPrevented(instance) ? instance.method_7947() : original.call(instance);
	}

	@WrapOperation(
		method = "isFullContainer",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I")
	)
	private static int modifyShulkerMaxCountStatic(class_1799 instance, Operation<Integer> original) {
		return Util.isHopperStackingPrevented(instance) ? 1 : original.call(instance);
	}

	@WrapOperation(
		method = "suckInItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Z",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/entity/HopperBlockEntity;addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/item/ItemEntity;)Z")
	)
	private static boolean limitCollectCount(class_1263 inventory, class_1542 itemEntity, Operation<Boolean> original) {
		if (!Util.isHopperStackingPrevented(itemEntity.method_6983())) return original.call(inventory, itemEntity);
		if (ShulkerFixSettings.hopperCollectSingleShulkers && inventory instanceof class_2614)
			return Util.collectOneItem(inventory, itemEntity);
		else if (ShulkerFixSettings.minecartCollectSingleShulkers && inventory instanceof class_1700)
			return Util.collectOneItem(inventory, itemEntity);
		else return original.call(inventory, itemEntity);
	}

	@WrapOperation(
		method = "method_31693",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/entity/HopperBlockEntity;addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/item/ItemEntity;)Z")
	)
	private static boolean limitHopperCollectCount(class_1263 inventory, class_1542 itemEntity, Operation<Boolean> original) {
		if (!Util.isHopperStackingPrevented(itemEntity.method_6983())) return original.call(inventory, itemEntity);
		if (ShulkerFixSettings.hopperCollectSingleShulkers)
			return Util.collectOneItem(inventory, itemEntity);
		else return original.call(inventory, itemEntity);
	}

	@Inject(
		method = "canMergeItems",
		at = @At("HEAD"),
		cancellable = true
	)
	private static void cancelItemMerging(class_1799 first, class_1799 second, CallbackInfoReturnable<Boolean> cir) {
		if (Util.isHopperStackingPrevented(first) || Util.isShulkerBox(second)) cir.setReturnValue(false);
	}
}