package dev.kikugie.shulkerfix.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import dev.kikugie.shulkerfix.Util;
import dev.kikugie.shulkerfix.carpet.ShulkerFixSettings;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1700;

@Mixin(class_1700.class)
public class HopperMinecartEntityMixin {
	@WrapOperation(
		method = "suckInItems",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/entity/HopperBlockEntity;addItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/item/ItemEntity;)Z")
	)
	private boolean limitCollectItems(class_1263 inventory, class_1542 itemEntity, Operation<Boolean> original) {
		return Util.isHopperStackingPrevented(itemEntity.method_6983())
			&& ShulkerFixSettings.minecartCollectSingleShulkers
			? Util.collectOneItem(inventory, itemEntity)
			: original.call(inventory, itemEntity);
	}
}
