package dev.kikugie.shulkerfix.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import dev.kikugie.shulkerfix.Util;
import dev.kikugie.shulkerfix.carpet.ShulkerFixSettings;
import net.minecraft.class_1542;
import net.minecraft.class_1799;

/**
 * Implements {@link ShulkerFixSettings#legacyShulkerItemMerging}.
 */
@Mixin(class_1542.class)
public class ItemEntityMixin {
	@Shadow
	private static void merge(class_1542 targetEntity, class_1799 targetStack, class_1542 sourceEntity, class_1799 sourceStack) {
	}

	@Inject(
		method = "tryToMerge(Lnet/minecraft/world/entity/item/ItemEntity;)V",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/item/ItemEntity;areMergable(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"),
		cancellable = true
	)
	private void applyLegacyMerge(class_1542 other, CallbackInfo ci, @Local(ordinal = 0) class_1799 selfStack, @Local(ordinal = 1) class_1799 otherStack) {
		if (!ShulkerFixSettings.legacyShulkerItemMerging || selfStack.method_7914() == 1 || !Util.isShulkerBox(selfStack)) return;

		class_1542 self = (class_1542) (Object) this;
		// Normally, items would only merge if their combined count is less or equals the max count.
		// Carpet used to ignore this behaviour, and so do we.
		// Entity owners are checked before invoking this mixin.
		if (selfStack.method_7947() < selfStack.method_7914() && class_1799.method_31577(selfStack, otherStack)) {
			// Carpet modified the 'Entity.age' instead of 'ItemEntity.itemAge',
			// which was actively used by various contraptions.
			self.field_6012 = Math.min(self.field_6012, other.field_6012);
			merge(self, selfStack, other, otherStack);
			ci.cancel();
		}
	}
}
