package dev.kikugie.shulkerfix.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import dev.kikugie.shulkerfix.Util;
import dev.kikugie.shulkerfix.carpet.ShulkerFixSettings;
import net.minecraft.class_1799;
import net.minecraft.class_9279;

import static net.minecraft.class_9334.field_49628;
import static net.minecraft.class_9334.field_50071;

/**
 * Implementation from the <a href="https://github.com/ch-yx/fabric-carpet/blob/18d4f8fdc02069fb4d41cd28d703f8d7a6aa7579/src/main/java/carpet/mixins/ItemStack_stackableShulkerBoxesEncodeMixin.java">ch-yx fork</a>.
 */
@Pseudo
@Mixin(targets = "net.minecraft.world.item.ItemStack$1")
public class ItemStackCodecMixin {
	@Unique
	private static final String MARKER = "__carpet_data!!the_max_stack_size_tag_is_fake!__";

	@ModifyVariable(method = "encode(Lnet/minecraft/network/RegistryFriendlyByteBuf;Lnet/minecraft/world/item/ItemStack;)V", at = @At("HEAD"), argsOnly = true)
	private class_1799 setModifiedStackSize(class_1799 stack) {
		if (ShulkerFixSettings.clientShulkerSync &&
			stack.method_58695(field_50071, 1) < stack.method_7947() &&
			!stack.method_58695(field_49628, class_9279.field_49302).method_57461().method_10545(MARKER) &&
			!Util.hasCustomMaxStackSize(stack)
		) {
			stack = stack.method_7972();
			stack.method_57379(field_50071, stack.method_7914());
			class_9279.method_57452(field_49628, stack, nbt -> nbt.method_10556(MARKER, true));
		}
		return stack;
	}

	@ModifyReturnValue(method = "decode(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lnet/minecraft/world/item/ItemStack;", at = @At("RETURN"))
	private class_1799 getModifiedStackSize(class_1799 stack) {
		// We still do decoding, in case the rule was disabled
		if (stack.method_58695(field_49628, class_9279.field_49302).method_57461().method_10545(MARKER)) {
			stack = stack.method_7972();
			stack.method_57379(field_50071, stack.method_58658().method_58694(field_50071));
			stack.method_58408(stack.method_7914());
			class_9279.method_57452(field_49628, stack, nbt -> nbt.method_10551(MARKER));
		}
		return stack;
	}
}
