package dev.kikugie.shulkerfix.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import dev.kikugie.shulkerfix.Util;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1799;

@Mixin(class_1703.class)
public class ScreenHandlerMixin {
	@WrapOperation(
		method = "getRedstoneSignalFromContainer(Lnet/minecraft/world/Container;)I",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/Container;getMaxStackSize(Lnet/minecraft/world/item/ItemStack;)I")
	)
	private static int fixOverstackedSignalStrength(class_1263 instance, class_1799 stack, Operation<Integer> original) {
		if (Util.isWrapped(instance)) return original.call(instance, stack);
		return Util.determineSignalStrengthContribution(stack);
	}

	@ModifyReturnValue(
		method = "getRedstoneSignalFromContainer(Lnet/minecraft/world/Container;)I",
		at = @At("RETURN")
	)
	private static int capComparatorSignalStrength(int original) {
		return Util.limitComparatorOutput(original);
	}
}