package dev.kikugie.shulkerfix.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import dev.kikugie.shulkerfix.Util;
import dev.kikugie.shulkerfix.carpet.ShulkerFixSettings;
import net.minecraft.class_1263;
import net.minecraft.class_1693;

/**
 * Provides two method qualifiers for 1.21.3 compatibility.
 */
@Mixin(class_1693.class)
public class StorageMinecartEntityMixin {
	@SuppressWarnings({"UnresolvedMixinReference", "UnnecessaryQualifiedMemberReference"})
	@ModifyArg(
		method = {
			//? if <=1.21.4
			//"Lnet/minecraft/entity/vehicle/AbstractMinecartContainer;method_7525()V",
			"applyNaturalSlowdown(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"
		},
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/world/inventory/AbstractContainerMenu;getRedstoneSignalFromContainer(Lnet/minecraft/world/Container;)I"
		),
		require = 1
	)
	private class_1263 fixMinecartSlowdown(class_1263 instance) {
		return ShulkerFixSettings.overstackedMinecartSlowdown ? instance : Util.wrapInventory(instance);
	}
}
