package dev.kikugie.shulkerfix.mixin.compat;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import dev.kikugie.shulkerfix.Util;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

/**
 * Prevents shulker stacking with Lithium installed.
 * <br>
 * <li>{@code me.jellysquid.mods.lithium.common.hopper.HopperHelper} is used for Lithium <0.14 compatibility.</li>
 * <li>{@code tryMoveSingleItem(Lnet/minecraft/inventory/Inventory;Lnet/minecraft/inventory/SidedInventory;Lnet/minecraft/item/ItemStack;ILnet/minecraft/util/math/Direction;)Z} is used for Lithium <0.13 compatibility.</li>
 */
@Pseudo
@Mixin(targets = {"net.caffeinemc.mods.lithium.common.hopper.HopperHelper", "me.jellysquid.mods.lithium.common.hopper.HopperHelper"})
public class LithiumHopperHelperMixin {
	@SuppressWarnings("UnresolvedMixinReference")
	@WrapOperation(
		method = {
			"determineComparatorUpdatePattern",
			"tryMoveSingleItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/WorldlyContainer;Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/core/Direction;)Z",
			"tryMoveSingleItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/WorldlyContainer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/core/Direction;)Z"
		},
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I")
	)
	private static int modifyShulkerMaxCount(class_1799 instance, Operation<Integer> original) {
		return Util.determineSignalStrengthContribution(instance);
	}

	//? if >=1.21.9 {
	@WrapOperation(method = "tryMoveSingleItem(Lnet/minecraft/world/Container;Lnet/minecraft/world/WorldlyContainer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/core/Direction;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/Container;getMaxStackSize()I"))
	private static int modifyShulkerStacking(class_1263 instance, Operation<Integer> original, @Local(argsOnly = true, ordinal = 0) class_1799 stack) {
		return Util.isHopperStackingPrevented(stack) ? 1 : original.call(instance);
	}
	//?}
}