package dev.kikugie.shulkerfix.mixin.compat;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import dev.kikugie.shulkerfix.Util;
import net.minecraft.class_1799;

/**
 * Prevents shulker stacking with Lithium installed.
 */
@Pseudo
@Mixin(targets = {"net.caffeinemc.mods.lithium.common.hopper.LithiumStackList", "me.jellysquid.mods.lithium.common.hopper.LithiumStackList"})
public class LithiumStackListMixin {
	@WrapOperation(
		method = "calculateSignalStrength",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I")
	)
	private int modifyShulkerMaxCount(class_1799 instance, Operation<Integer> original) {
		return Util.determineSignalStrengthContribution(instance);
	}

	@ModifyReturnValue(
		method = "calculateSignalStrength",
		at = @At("RETURN"),
		remap = false
	)
	private int capComparatorSignalStrength(int original) {
		return Util.limitComparatorOutput(original);
	}
}
