/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos;

import as.sirhephaistos.simplybetter.core.PlayerSessionTracker;
import as.sirhephaistos.simplybetter.core.db.AccountsCrudManager;
import as.sirhephaistos.simplybetter.core.db.AfksCrudManager;
import as.sirhephaistos.simplybetter.core.db.AuditLogsCrudManager;
import as.sirhephaistos.simplybetter.core.db.BackLocationsCrudManager;
import as.sirhephaistos.simplybetter.core.db.BansCrudManager;
import as.sirhephaistos.simplybetter.core.db.BansIpCrudManager;
import as.sirhephaistos.simplybetter.core.db.ChatLogsCrudManager;
import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.core.db.HomesCrudManager;
import as.sirhephaistos.simplybetter.core.db.IgnoresCrudManager;
import as.sirhephaistos.simplybetter.core.db.JailSanctionsCrudManager;
import as.sirhephaistos.simplybetter.core.db.JailsCrudManager;
import as.sirhephaistos.simplybetter.core.db.KitCooldownsCrudManager;
import as.sirhephaistos.simplybetter.core.db.KitItemsCrudManager;
import as.sirhephaistos.simplybetter.core.db.KitsCrudManager;
import as.sirhephaistos.simplybetter.core.db.MailsCrudManager;
import as.sirhephaistos.simplybetter.core.db.MutesCrudManager;
import as.sirhephaistos.simplybetter.core.db.PlayersCrudManager;
import as.sirhephaistos.simplybetter.core.db.PositionsCrudManager;
import as.sirhephaistos.simplybetter.core.db.PrivateChatLogsCrudManager;
import as.sirhephaistos.simplybetter.core.db.RtpSettingsCrudManager;
import as.sirhephaistos.simplybetter.core.db.SocialSpysCrudManager;
import as.sirhephaistos.simplybetter.core.db.TransactionsCrudManager;
import as.sirhephaistos.simplybetter.core.db.UserLogsCrudManager;
import as.sirhephaistos.simplybetter.core.db.WarpsCrudManager;
import as.sirhephaistos.simplybetter.core.db.WorldsCrudManager;
import as.sirhephaistos.simplybetter.library.PlayerDTO;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplyBetterCoreServer
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "simplybetter-core";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"simplybetter-core");
    private final boolean force = true;
    private final PlayerSessionTracker sessionTracker = new PlayerSessionTracker();
    private static DatabaseManager DB;
    private static AccountsCrudManager accountsCrudManager;
    private static AfksCrudManager afksCrudManager;
    private static AuditLogsCrudManager auditLogsCrudManager;
    private static BackLocationsCrudManager backLocationsCrudManager;
    private static BansCrudManager bansCrudManager;
    private static BansIpCrudManager bansIpCrudManager;
    private static ChatLogsCrudManager chatLogsCrudManager;
    private static HomesCrudManager homesCrudManager;
    private static IgnoresCrudManager ignoresCrudManager;
    private static JailsCrudManager jailsCrudManager;
    private static JailSanctionsCrudManager jailSanctionsCrudManager;
    private static KitCooldownsCrudManager kitCooldownsCrudManager;
    private static KitItemsCrudManager kitItemsCrudManager;
    private static KitsCrudManager kitsCrudManager;
    private static MailsCrudManager mailsCrudManager;
    private static MutesCrudManager mutesCrudManager;
    private static PlayersCrudManager playersCrudManager;
    private static PositionsCrudManager positionsCrudManager;
    private static PrivateChatLogsCrudManager privateChatLogsCrudManager;
    private static RtpSettingsCrudManager rtpSettingsCrudManager;
    private static SocialSpysCrudManager socialSpysCrudManager;
    private static TransactionsCrudManager transactionsCrudManager;
    private static UserLogsCrudManager userLogsCrudManager;
    private static WarpsCrudManager warpsCrudManager;
    private static WorldsCrudManager worldsCrudManager;

    public static DatabaseManager db() {
        return DB;
    }

    public void onInitializeServer() {
        LOGGER.info("[{}] Initializing database...", (Object)MOD_ID);
        try {
            DB = DatabaseManager.createDefault();
            DB.init();
        }
        catch (Exception e) {
            LOGGER.error("[{}] Failed to initialize database: {}", new Object[]{MOD_ID, e.getMessage(), e});
            return;
        }
        LOGGER.info("[{}] database initialized.", (Object)MOD_ID);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            try {
                if (DB != null) {
                    DB.shutdown(Duration.ofSeconds(5L));
                    LOGGER.info("[{}] database shut down.", (Object)MOD_ID);
                }
            }
            catch (Exception e) {
                LOGGER.error("[{}] Failed to shut down database: {}", new Object[]{MOD_ID, e.getMessage(), e});
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (playersCrudManager.hasAnyPlayers()) {
                // empty if block
            }
            this.loadPlayersFromUserCache(server);
        });
        ServerPlayConnectionEvents.JOIN.register(this::onPlayerJoin);
        ServerPlayConnectionEvents.DISCONNECT.register(this::onPlayerDisconnect);
        LOGGER.info("[{}] Initializing modules", (Object)MOD_ID);
        this.initializeAllCrudManagers();
        LOGGER.info("[{}] Modules initialized", (Object)MOD_ID);
    }

    private void onPlayerDisconnect(class_3244 connection, MinecraftServer minecraftServer) {
        try {
            class_3222 player = connection.method_32311();
            String uuid = player.method_5667().toString();
            String now = Instant.now().toString();
            long sessionSeconds = this.sessionTracker.onLeave(uuid);
            if (sessionSeconds <= 0L) {
                return;
            }
            Optional<PlayerDTO> existing = playersCrudManager.getPlayerByUuid(uuid);
            if (existing.isEmpty()) {
                PlayerDTO dto = new PlayerDTO(uuid, player.method_7334().getName(), now, now, sessionSeconds, false, null, null);
                playersCrudManager.upsertPlayer(dto);
                return;
            }
            PlayerDTO p = existing.get();
            long newPlaytime = p.playtimeSeconds() + sessionSeconds;
            PlayerDTO updated = new PlayerDTO(p.uuid(), p.name(), p.firstSeen(), now, newPlaytime, p.canBeIgnored(), p.nickname(), p.lastSeenPositionId());
            playersCrudManager.upsertPlayer(updated);
            LOGGER.info("[{}] playtime updated: {}", (Object)MOD_ID, (Object)updated.playtimeSeconds());
        }
        catch (Exception e) {
            LOGGER.error("[{}] Failed to update playtime: {}", new Object[]{MOD_ID, e.getMessage(), e});
        }
    }

    private void onPlayerJoin(class_3244 connection, PacketSender packetSender, MinecraftServer server) {
        try {
            PlayerDTO dto;
            class_3222 player = connection.method_32311();
            String uuid = player.method_5667().toString();
            this.sessionTracker.onJoin(uuid);
            LOGGER.info("[{}] started playtime counter for this game session for player: {}", (Object)MOD_ID, (Object)player.method_7334().getName());
            String name = player.method_7334().getName();
            String now = Instant.now().toString();
            Optional<PlayerDTO> existing = playersCrudManager.getPlayerByUuid(uuid);
            if (existing.isPresent()) {
                PlayerDTO p = existing.get();
                dto = new PlayerDTO(p.uuid(), name, p.firstSeen(), now, p.playtimeSeconds(), p.canBeIgnored(), p.nickname(), p.lastSeenPositionId());
            } else {
                dto = new PlayerDTO(uuid, name, now, now, 0L, false, null, null);
            }
            playersCrudManager.upsertPlayer(dto);
            LOGGER.info("[{}] upserted player on join: {}", (Object)MOD_ID, (Object)name);
        }
        catch (Exception e) {
            LOGGER.error("[{}] Failed to upsert player on join: {}", new Object[]{MOD_ID, e.getMessage(), e});
        }
    }

    private void loadPlayersFromUserCache(MinecraftServer server) {
        LOGGER.info("[{}] Loading usercache... to retrieve existing player uuid", (Object)MOD_ID);
        Path path = server.method_3758("usercache.json");
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("[{}] Usercache.json not found at {}", (Object)MOD_ID, (Object)path.toAbsolutePath());
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Gson gson = new Gson();
            UserCacheEntry[] entries = (UserCacheEntry[])gson.fromJson((Reader)reader, UserCacheEntry[].class);
            LOGGER.info("[{}] Usercache.json loaded: {} entries.", (Object)MOD_ID, (Object)entries.length);
            int loadedCount = 0;
            for (UserCacheEntry entry : entries) {
                String uuid = entry.getUuid();
                String name = entry.getName();
                String iso = this.toIsoInstant(entry.getExpiresOn());
                String adjustedExpiresOn = Instant.parse(iso).minus(Duration.ofDays(30L)).toString();
                Optional<PlayerDTO> existingPlayerOpt = playersCrudManager.getPlayerByUuid(uuid);
                if (!existingPlayerOpt.isEmpty()) continue;
                PlayerDTO newPlayer = new PlayerDTO(uuid, name, adjustedExpiresOn, adjustedExpiresOn, 0L, true, null, null);
                PlayerDTO created = playersCrudManager.createPlayer(newPlayer);
                ++loadedCount;
            }
            LOGGER.info("[{}] Loaded {} players from usercache.json", (Object)MOD_ID, (Object)loadedCount);
        }
        catch (Exception e) {
            LOGGER.error("[{}] Failed to load usercache: {}", new Object[]{MOD_ID, e.getMessage(), e});
        }
    }

    private String toIsoInstant(String rawExpiresOn) {
        String[] parts = rawExpiresOn.trim().split(" ");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Unexpected expiresOn format: " + rawExpiresOn);
        }
        String date = parts[0];
        String time = parts[1];
        Object offset = parts[2];
        if (((String)offset).length() == 5 && (((String)offset).charAt(0) == '+' || ((String)offset).charAt(0) == '-')) {
            offset = ((String)offset).substring(0, 3) + ":" + ((String)offset).substring(3);
        }
        return date + "T" + time + (String)offset;
    }

    private void initializeAllCrudManagers() {
        accountsCrudManager = new AccountsCrudManager(DB);
        afksCrudManager = new AfksCrudManager(DB);
        auditLogsCrudManager = new AuditLogsCrudManager(DB);
        backLocationsCrudManager = new BackLocationsCrudManager(DB);
        bansCrudManager = new BansCrudManager(DB);
        bansIpCrudManager = new BansIpCrudManager(DB);
        chatLogsCrudManager = new ChatLogsCrudManager(DB);
        homesCrudManager = new HomesCrudManager(DB);
        ignoresCrudManager = new IgnoresCrudManager(DB);
        jailsCrudManager = new JailsCrudManager(DB);
        jailSanctionsCrudManager = new JailSanctionsCrudManager(DB);
        kitCooldownsCrudManager = new KitCooldownsCrudManager(DB);
        kitItemsCrudManager = new KitItemsCrudManager(DB);
        kitsCrudManager = new KitsCrudManager(DB);
        mailsCrudManager = new MailsCrudManager(DB);
        mutesCrudManager = new MutesCrudManager(DB);
        playersCrudManager = new PlayersCrudManager(DB);
        positionsCrudManager = new PositionsCrudManager(DB);
        privateChatLogsCrudManager = new PrivateChatLogsCrudManager(DB);
        rtpSettingsCrudManager = new RtpSettingsCrudManager(DB);
        socialSpysCrudManager = new SocialSpysCrudManager(DB);
        transactionsCrudManager = new TransactionsCrudManager(DB);
        userLogsCrudManager = new UserLogsCrudManager(DB);
        warpsCrudManager = new WarpsCrudManager(DB, positionsCrudManager);
        worldsCrudManager = new WorldsCrudManager(DB);
    }

    public static AccountsCrudManager getAccountsCrudManager() {
        return accountsCrudManager;
    }

    public static AfksCrudManager getAfksCrudManager() {
        return afksCrudManager;
    }

    public static AuditLogsCrudManager getAuditLogsCrudManager() {
        return auditLogsCrudManager;
    }

    public static BackLocationsCrudManager getBackLocationsCrudManager() {
        return backLocationsCrudManager;
    }

    public static BansCrudManager getBansCrudManager() {
        return bansCrudManager;
    }

    public static BansIpCrudManager getBansIpCrudManager() {
        return bansIpCrudManager;
    }

    public static ChatLogsCrudManager getChatLogsCrudManager() {
        return chatLogsCrudManager;
    }

    public static HomesCrudManager getHomesCrudManager() {
        return homesCrudManager;
    }

    public static IgnoresCrudManager getIgnoresCrudManager() {
        return ignoresCrudManager;
    }

    public static JailsCrudManager getJailsCrudManager() {
        return jailsCrudManager;
    }

    public static JailSanctionsCrudManager getJailSanctionsCrudManager() {
        return jailSanctionsCrudManager;
    }

    public static KitCooldownsCrudManager getKitCooldownsCrudManager() {
        return kitCooldownsCrudManager;
    }

    public static KitItemsCrudManager getKitItemsCrudManager() {
        return kitItemsCrudManager;
    }

    public static KitsCrudManager getKitsCrudManager() {
        return kitsCrudManager;
    }

    public static MailsCrudManager getMailsCrudManager() {
        return mailsCrudManager;
    }

    public static MutesCrudManager getMutesCrudManager() {
        return mutesCrudManager;
    }

    public static PlayersCrudManager getPlayersCrudManager() {
        return playersCrudManager;
    }

    public static PositionsCrudManager getPositionsCrudManager() {
        return positionsCrudManager;
    }

    public static PrivateChatLogsCrudManager getPrivateChatLogsCrudManager() {
        return privateChatLogsCrudManager;
    }

    public static RtpSettingsCrudManager getRtpSettingsCrudManager() {
        return rtpSettingsCrudManager;
    }

    public static SocialSpysCrudManager getSocialSpysCrudManager() {
        return socialSpysCrudManager;
    }

    public static TransactionsCrudManager getTransactionsCrudManager() {
        return transactionsCrudManager;
    }

    public static UserLogsCrudManager getUserLogsCrudManager() {
        return userLogsCrudManager;
    }

    public static WarpsCrudManager getWarpsCrudManager() {
        return warpsCrudManager;
    }

    public static WorldsCrudManager getWorldsCrudManager() {
        return worldsCrudManager;
    }

    private static final class UserCacheEntry {
        String name;
        String uuid;
        String expiresOn;

        private UserCacheEntry() {
        }

        public String getName() {
            return this.name;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getExpiresOn() {
            return this.expiresOn;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setExpiresOn(String expiresOn) {
            this.expiresOn = expiresOn;
        }
    }
}

