/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerSessionTracker {
    private final Map<String, Instant> joinTimes = new ConcurrentHashMap<String, Instant>();

    public void onJoin(String uuid) {
        this.joinTimes.put(uuid, Instant.now());
    }

    public long onLeave(String uuid) {
        Instant joined = this.joinTimes.remove(uuid);
        if (joined == null) {
            return 0L;
        }
        return Duration.between(joined, Instant.now()).getSeconds();
    }
}

