/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.library.AccountDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class AccountsCrudManager {
    private final DatabaseManager db;

    public AccountsCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
    }

    private static AccountDTO mapAccount(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("rs is null");
        }
        @NotNull String playerUuid = rs.getString("a_player_uuid");
        if (playerUuid == null) {
            throw new IllegalStateException("player_uuid is null");
        }
        long balance = rs.getLong("a_balance");
        if (rs.wasNull()) {
            throw new IllegalStateException("balance is null");
        }
        @NotNull String updatedAt = rs.getString("a_updated_at");
        if (updatedAt == null) {
            throw new IllegalStateException("updated_at is null");
        }
        return new AccountDTO(playerUuid, balance, updatedAt);
    }

    public AccountDTO createAccount(@NotNull String playerUuid, long balance, @NotNull String updatedAt) {
        String id;
        if (this.getAccountByPlayerUuid(playerUuid).isPresent()) {
            throw new IllegalArgumentException("Account already exists for playerUuid=" + playerUuid);
        }
        String sql = "INSERT INTO sb_accounts (player_uuid, balance, updated_at)\nVALUES (?, ?, ?)\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("INSERT INTO sb_accounts (player_uuid, balance, updated_at)\nVALUES (?, ?, ?)\n", 1);){
            ps.setString(1, playerUuid);
            ps.setLong(2, balance);
            ps.setString(3, updatedAt);
            ps.executeUpdate();
            try (ResultSet keys = ps.getGeneratedKeys();){
                if (!keys.next()) {
                    throw new RuntimeException("No generated key");
                }
                id = keys.getString(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed for playerUuid=" + playerUuid, e);
        }
        return this.getAccountByPlayerUuid(id).orElseThrow(() -> new RuntimeException("Post-fetch missing playerUuid=" + id));
    }

    /*
     * Exception decompiling
     */
    public Optional<AccountDTO> getAccountByPlayerUuid(@NotNull String playerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<AccountDTO> getAllAccounts() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<AccountDTO> getAllAccountsPaged(int limit, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AccountDTO updateAccount(@NotNull String playerUuid, long balance, @NotNull String updatedAt) {
        String sql = "UPDATE sb_accounts\nSET balance = ?, updated_at = ?\nWHERE playerUuid = ?\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("UPDATE sb_accounts\nSET balance = ?, updated_at = ?\nWHERE playerUuid = ?\n");){
            ps.setLong(1, balance);
            ps.setString(2, updatedAt);
            int upd = ps.executeUpdate();
            if (upd == 0) {
                throw new RuntimeException("Affected 0 rows for playerUuid=" + playerUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed for playerUuid=" + playerUuid, e);
        }
        return this.getAccountByPlayerUuid(playerUuid).orElseThrow(() -> new RuntimeException("Post-fetch missing playerUuid=" + playerUuid));
    }

    public void deleteAccountByPlayerUuid(@NotNull String playerUuid) {
        if (this.getAccountByPlayerUuid(playerUuid).isEmpty()) {
            throw new IllegalArgumentException("Account not found for playerUuid=" + playerUuid);
        }
        String sql = "DELETE FROM sb_accounts\nWHERE player_uuid = ?\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("DELETE FROM sb_accounts\nWHERE player_uuid = ?\n");){
            ps.setString(1, playerUuid);
            ps.executeUpdate();
            if (ps.getUpdateCount() == 0) {
                throw new RuntimeException("Affected 0 rows for playerUuid=" + playerUuid);
            }
            if (this.getAccountByPlayerUuid(playerUuid).isPresent()) {
                throw new RuntimeException("Failed to delete for playerUuid=" + playerUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed for playerUuid=" + playerUuid, e);
        }
    }
}

