/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.library.AfkDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AfksCrudManager {
    private final DatabaseManager db;

    public AfksCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
    }

    private static AfkDTO mapAfk(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("rs cannot be null");
        }
        if (rs.getString("a_player_uuid") == null) {
            throw new IllegalStateException("a_player_uuid cannot be null");
        }
        if (rs.getString("a_since") == null) {
            throw new IllegalStateException("a_since cannot be null");
        }
        @NotNull String playerUuid = rs.getString("a_player_uuid");
        @NotNull String since = rs.getString("a_since");
        String message = rs.getString("a_message");
        return new AfkDTO(playerUuid, since, message);
    }

    public AfkDTO createAfk(@NotNull String playerUuid, @NotNull String since, @Nullable String message) {
        String id;
        if (this.getAfkByPlayerUuid(playerUuid).isPresent()) {
            throw new IllegalArgumentException("createAfk: AFK entry already exists for playerUuid=" + playerUuid);
        }
        String sql = "INSERT INTO sb_afks (player_uuid, since, message)\nVALUES (?, ?, ?)\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("INSERT INTO sb_afks (player_uuid, since, message)\nVALUES (?, ?, ?)\n");){
            ps.setString(1, playerUuid);
            ps.setString(2, since);
            if (message == null) {
                ps.setNull(3, 12);
            } else {
                ps.setString(3, message);
            }
            ps.executeUpdate();
            try (ResultSet keys = ps.getGeneratedKeys();){
                if (!keys.next()) {
                    throw new RuntimeException("No generated keys");
                }
                id = keys.getString(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("createAfk: failed for playerUuid=" + playerUuid, e);
        }
        return this.getAfkByPlayerUuid(id).orElseThrow(() -> new RuntimeException("createAfk: post-fetch missing for playerUuid=" + playerUuid));
    }

    /*
     * Exception decompiling
     */
    public Optional<AfkDTO> getAfkByPlayerUuid(@NotNull String playerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<AfkDTO> getAllAfks() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<AfkDTO> getAllAfksPaged(int limit, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean existsAfkForPlayer(@NotNull String playerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AfkDTO updateAfk(@NotNull String playerUuid, @NotNull String since, @Nullable String message) {
        String sql = "UPDATE sb_afks\nSET since = ?, message = ?\nWHERE player_uuid = ?\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("UPDATE sb_afks\nSET since = ?, message = ?\nWHERE player_uuid = ?\n");){
            ps.setString(1, since);
            if (message == null) {
                ps.setNull(2, 12);
            } else {
                ps.setString(2, message);
            }
            ps.setString(3, playerUuid);
            int upd = ps.executeUpdate();
            if (upd == 0) {
                throw new RuntimeException("updateAfk: affected 0 rows for playerUuid=" + playerUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("updateAfk: failed for playerUuid=" + playerUuid, e);
        }
        return this.getAfkByPlayerUuid(playerUuid).orElseThrow(() -> new RuntimeException("updateAfk: post-fetch missing for playerUuid=" + playerUuid));
    }

    public AfkDTO setAfkMessage(@NotNull String playerUuid, @Nullable String message) {
        String sql = "UPDATE sb_afks\nSET message = ?\nWHERE player_uuid = ?\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("UPDATE sb_afks\nSET message = ?\nWHERE player_uuid = ?\n");){
            if (message == null) {
                ps.setNull(1, 12);
            } else {
                ps.setString(1, message);
            }
            ps.setString(2, playerUuid);
            int upd = ps.executeUpdate();
            if (upd == 0) {
                throw new RuntimeException("setAfkMessage: affected 0 rows for playerUuid=" + playerUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("setAfkMessage: failed for playerUuid=" + playerUuid, e);
        }
        return this.getAfkByPlayerUuid(playerUuid).orElseThrow(() -> new RuntimeException("setAfkMessage: post-fetch missing for playerUuid=" + playerUuid));
    }

    public AfkDTO setAfkSince(@NotNull String playerUuid, @NotNull String since) {
        String sql = "UPDATE sb_afks\nSET since = ?\nWHERE player_uuid = ?\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("UPDATE sb_afks\nSET since = ?\nWHERE player_uuid = ?\n");){
            ps.setString(1, since);
            ps.setString(2, playerUuid);
            int upd = ps.executeUpdate();
            if (upd == 0) {
                throw new RuntimeException("setAfkSinceSeconds: affected 0 rows for playerUuid=" + playerUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("setAfkSinceSeconds: failed for playerUuid=" + playerUuid, e);
        }
        return this.getAfkByPlayerUuid(playerUuid).orElseThrow(() -> new RuntimeException("setAfkSinceSeconds: post-fetch missing for playerUuid=" + playerUuid));
    }

    public void deleteAfkByPlayerUuid(@NotNull String playerUuid) {
        if (!this.existsAfkForPlayer(playerUuid)) {
            throw new IllegalStateException("deleteAfkByPlayerUuid: no AFK entry for playerUuid=" + playerUuid);
        }
        String sql = "DELETE FROM sb_afks\nWHERE player_uuid = ?\n";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("DELETE FROM sb_afks\nWHERE player_uuid = ?\n");){
            ps.setString(1, playerUuid);
            ps.executeUpdate();
            if (ps.executeUpdate() == 0) {
                throw new RuntimeException("deleteAfkByPlayerUuid: affected 0 rows for playerUuid=" + playerUuid);
            }
            if (this.existsAfkForPlayer(playerUuid)) {
                throw new RuntimeException("deleteAfkByPlayerUuid: failed to delete for playerUuid=" + playerUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("deleteAfkByPlayerUuid: failed for playerUuid=" + playerUuid, e);
        }
    }
}

