/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.library.AuditLogDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AuditLogsCrudManager {
    private final DatabaseManager db;

    public AuditLogsCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
    }

    private static AuditLogDTO mapAuditLog(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("mapAuditLog: ResultSet cannot be null");
        }
        if (rs.getLong("id") < 1L) {
            throw new IllegalStateException("mapAuditLog: ResultSet is not positioned on a valid row");
        }
        if (rs.getString("table_name") == null) {
            throw new IllegalStateException("mapAuditLog: ResultSet is missing required column: table_name");
        }
        if (rs.getString("at") == null) {
            throw new IllegalStateException("mapAuditLog: ResultSet is missing required column: at");
        }
        long id = rs.getLong("id");
        String tableName = rs.getString("table_name");
        String initiator = rs.getString("initiator");
        String contextJson = rs.getString("context_json");
        String at = rs.getString("at");
        return new AuditLogDTO(id, tableName, initiator, contextJson, at);
    }

    /*
     * Exception decompiling
     */
    public AuditLogDTO createAuditLog(@NotNull String tableName, @Nullable String initiator, @Nullable String contextJson, @NotNull String at) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Optional<AuditLogDTO> getAuditLogById(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<AuditLogDTO> getAllAuditLogs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<AuditLogDTO> getAuditLogsForTable(@NotNull String tableName, int limit) {
        String sql = "SELECT id, table_name, initiator, context_json, at\nFROM sb_audit_logs\nWHERE table_name = ?\nORDER BY id DESC\nLIMIT ?\n";
        ArrayList<AuditLogDTO> out = new ArrayList<AuditLogDTO>();
        try (Connection conn = this.db.getConnection();){
            ArrayList<AuditLogDTO> arrayList;
            block22: {
                PreparedStatement ps = conn.prepareStatement("SELECT id, table_name, initiator, context_json, at\nFROM sb_audit_logs\nWHERE table_name = ?\nORDER BY id DESC\nLIMIT ?\n");
                try {
                    ps.setString(1, tableName);
                    ps.setInt(2, Math.max(0, limit));
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            out.add(AuditLogsCrudManager.mapAuditLog(rs));
                        }
                    }
                    arrayList = out;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing audit logs for table=" + tableName, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<AuditLogDTO> getAuditLogsByInitiator(@NotNull String initiator, int limit) {
        String sql = "SELECT id, table_name, initiator, context_json, at\nFROM sb_audit_logs\nWHERE initiator = ?\nORDER BY id DESC\nLIMIT ?\n";
        ArrayList<AuditLogDTO> out = new ArrayList<AuditLogDTO>();
        try (Connection conn = this.db.getConnection();){
            ArrayList<AuditLogDTO> arrayList;
            block22: {
                PreparedStatement ps = conn.prepareStatement("SELECT id, table_name, initiator, context_json, at\nFROM sb_audit_logs\nWHERE initiator = ?\nORDER BY id DESC\nLIMIT ?\n");
                try {
                    ps.setString(1, initiator);
                    ps.setInt(2, Math.max(0, limit));
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            out.add(AuditLogsCrudManager.mapAuditLog(rs));
                        }
                    }
                    arrayList = out;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing audit logs for initiator=" + initiator, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<AuditLogDTO> getAuditLogsBetween(@NotNull String fromInclusive, @NotNull String toExclusive, int limit) {
        if (limit == 0 || limit < -1) {
            throw new IllegalArgumentException("Limit must be positive or -1 for no limit");
        }
        Object sql = "SELECT id, table_name, initiator, context_json, at\nFROM sb_audit_logs\nWHERE at >= ? AND at < ?\nORDER BY at ASC";
        if (limit == 1) {
            sql = (String)sql + " LIMIT ?";
        }
        ArrayList<AuditLogDTO> out = new ArrayList<AuditLogDTO>();
        try (Connection conn = this.db.getConnection();){
            ArrayList<AuditLogDTO> arrayList;
            block25: {
                PreparedStatement ps = conn.prepareStatement((String)sql);
                try {
                    ps.setString(1, fromInclusive);
                    ps.setString(2, toExclusive);
                    if (limit == 1) {
                        ps.setInt(3, limit);
                    }
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            out.add(AuditLogsCrudManager.mapAuditLog(rs));
                        }
                    }
                    arrayList = out;
                    if (ps == null) break block25;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing audit logs between [" + fromInclusive + ", " + toExclusive + ")", e);
        }
    }

    public void updateAuditLog() {
        throw new UnsupportedOperationException("Audit logs cannot be updated once created.");
    }

    public void deleteAuditLogById(long id) {
        if (this.getAuditLogById(id).isEmpty()) {
            throw new IllegalArgumentException("deleteAuditLogById: No audit log found for id=" + id);
        }
        String sql = "DELETE FROM sb_audit_logs WHERE id = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_audit_logs WHERE id = ?");){
            ps.setLong(1, id);
            ps.executeUpdate();
            if (ps.getUpdateCount() == 0) {
                throw new RuntimeException("deleteAuditLogById: affected 0 rows for id=" + id);
            }
            if (this.getAuditLogById(id).isPresent()) {
                throw new RuntimeException("deleteAuditLogById: failed to delete for id=" + id);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting audit log id=" + id, e);
        }
    }
}

