/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.core.db.PositionsCrudManager;
import as.sirhephaistos.simplybetter.library.BackLocationDTO;
import as.sirhephaistos.simplybetter.library.PositionDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class BackLocationsCrudManager {
    private final DatabaseManager db;

    public BackLocationsCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
    }

    private static BackLocationDTO map(@NotNull ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("ResultSet must not be null");
        }
        if (rs.getString("player_uuid") == null) {
            throw new IllegalStateException("player_uuid column is null");
        }
        if (rs.getString("updated_at") == null) {
            throw new IllegalStateException("updated_at column is null");
        }
        String playerUuid = rs.getString("player_uuid");
        String updatedAt = rs.getString("updated_at");
        long prev = rs.getLong("previous_position_id");
        long curr = rs.getLong("current_position_id");
        return new BackLocationDTO(playerUuid, updatedAt, prev, curr);
    }

    public BackLocationDTO createBackLocation(@NotNull String playerUuid, @NotNull String updatedAt, PositionDTO previousPosition, PositionDTO currentPosition) {
        String id;
        if (this.getBackLocationByPlayerUuid(playerUuid).isEmpty()) {
            throw new IllegalArgumentException("Back location for playerUuid=" + playerUuid + " already exists");
        }
        PositionsCrudManager positionsCrudManager = new PositionsCrudManager(this.db);
        if (previousPosition.id() == null) {
            previousPosition = positionsCrudManager.createPosition(previousPosition.dimensionId(), previousPosition.x(), previousPosition.y(), previousPosition.z(), previousPosition.yRot(), previousPosition.xRot());
        }
        if (currentPosition.id() == null) {
            currentPosition = positionsCrudManager.createPosition(currentPosition.dimensionId(), currentPosition.x(), currentPosition.y(), currentPosition.z(), currentPosition.yRot(), currentPosition.xRot());
        }
        if (previousPosition.id() == null || currentPosition.id() == null) {
            throw new IllegalStateException("Position IDs must not be null after creation");
        }
        String sql = "INSERT INTO sb_back_locations (player_uuid, updated_at, previous_position_id, current_position_id)\nVALUES (?, ?, ?, ?)\n";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("INSERT INTO sb_back_locations (player_uuid, updated_at, previous_position_id, current_position_id)\nVALUES (?, ?, ?, ?)\n");){
            ps.setString(1, playerUuid);
            ps.setString(2, updatedAt);
            ps.setLong(3, previousPosition.id());
            ps.setLong(4, currentPosition.id());
            ps.executeUpdate();
            try (ResultSet keys = ps.getGeneratedKeys();){
                if (!keys.next()) {
                    throw new RuntimeException("No generated keys");
                }
                id = keys.getString(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error creating back location for playerUuid=" + playerUuid, e);
        }
        return this.getBackLocationByPlayerUuid(id).orElseThrow(() -> new RuntimeException("Post-fetch missing for playerUuid=" + playerUuid));
    }

    /*
     * Exception decompiling
     */
    public Optional<BackLocationDTO> getBackLocationByPlayerUuid(@NotNull String playerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<BackLocationDTO> getAllBackLocations() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<BackLocationDTO> getAllBackLocationsPaged(int limit, int offset) {
        String sql = "SELECT player_uuid, updated_at, previous_position_id, current_position_id\nFROM sb_back_locations\nORDER BY updated_at DESC\nLIMIT ? OFFSET ?\n";
        ArrayList<BackLocationDTO> out = new ArrayList<BackLocationDTO>();
        try (Connection conn = this.db.getConnection();){
            ArrayList<BackLocationDTO> arrayList;
            block22: {
                PreparedStatement ps = conn.prepareStatement("SELECT player_uuid, updated_at, previous_position_id, current_position_id\nFROM sb_back_locations\nORDER BY updated_at DESC\nLIMIT ? OFFSET ?\n");
                try {
                    ps.setInt(1, limit);
                    ps.setInt(2, offset);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            out.add(BackLocationsCrudManager.map(rs));
                        }
                    }
                    arrayList = out;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing paged back locations", e);
        }
    }

    public BackLocationDTO updateBackLocation(@NotNull String playerUuid, PositionDTO previousPosition, PositionDTO newPosition, @NotNull String updatedAt) {
        if (this.getBackLocationByPlayerUuid(playerUuid).isEmpty()) {
            throw new IllegalArgumentException("Back location for playerUuid=" + playerUuid + " does not exist");
        }
        this.deleteBackLocationByPlayerUuid(playerUuid);
        return this.createBackLocation(playerUuid, updatedAt, previousPosition, newPosition);
    }

    public void deleteBackLocationByPlayerUuid(@NotNull String playerUuid) {
        if (this.getBackLocationByPlayerUuid(playerUuid).isEmpty()) {
            throw new IllegalArgumentException("Back location for playerUuid=" + playerUuid + " does not exist");
        }
        String sql = "DELETE FROM sb_back_locations WHERE player_uuid = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_back_locations WHERE player_uuid = ?");){
            ps.setString(1, playerUuid);
            int affected = ps.executeUpdate();
            if (affected == 0) {
                throw new RuntimeException("No back location deleted for playerUuid=" + playerUuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting back location for playerUuid=" + playerUuid, e);
        }
    }
}

