/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.core.db.PositionsCrudManager;
import as.sirhephaistos.simplybetter.library.HomeDTO;
import as.sirhephaistos.simplybetter.library.PositionDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class HomesCrudManager {
    private final DatabaseManager db;
    private static PositionsCrudManager positionsCrudManager;

    public HomesCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
        positionsCrudManager = new PositionsCrudManager(db);
    }

    private static HomeDTO mapHomes(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("rs is null");
        }
        long id = rs.getLong("id");
        if (rs.wasNull()) {
            throw new IllegalStateException("id is null");
        }
        @NotNull String name = rs.getString("name");
        if (name == null) {
            throw new IllegalStateException("name is null");
        }
        @NotNull String ownerUuid = rs.getString("owner_uuid");
        if (ownerUuid == null) {
            throw new IllegalStateException("owner_uuid is null");
        }
        long positionId = rs.getLong("position_id");
        if (rs.wasNull()) {
            throw new IllegalStateException("position_id is null");
        }
        @NotNull String createdAt = rs.getString("created_at");
        if (createdAt == null) {
            throw new IllegalStateException("created_at is null");
        }
        @NotNull PositionDTO position = positionsCrudManager.getPositionById(positionId).orElseThrow(() -> new IllegalStateException("position with id " + positionId + " does not exist"));
        return new HomeDTO(id, name, createdAt, ownerUuid, position.id());
    }

    private static String strReformat(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String is null");
        }
        return s.replaceAll("[^a-zA-Z0-9_]", "").replace(" ", "_").toLowerCase();
    }

    public HomeDTO createHome(@NotNull String name, @NotNull String createdAt, @NotNull String ownerUuid, @NotNull PositionDTO positionDTO) {
        long id;
        name = HomesCrudManager.strReformat(name);
        String sql = "INSERT INTO sb_homes (name, created_at, owner_uuid, position_id) VALUES (?, ?, ?, ?);";
        if (positionDTO.id() == null && (positionDTO = positionsCrudManager.createPosition(positionDTO)).id() == null) {
            throw new IllegalStateException("Failed to create position for home");
        }
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("INSERT INTO sb_homes (name, created_at, owner_uuid, position_id) VALUES (?, ?, ?, ?);");){
            ps.setString(1, name);
            ps.setString(2, createdAt);
            ps.setString(3, ownerUuid);
            ps.setLong(4, positionDTO.id());
            ps.executeUpdate();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (!rs.next()) {
                    throw new RuntimeException("Failed to get generated key");
                }
                id = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error creating home", e);
        }
        return this.getHomeById(id).orElseThrow(() -> new IllegalStateException("Failed to retrieve created home with id " + id));
    }

    public HomeDTO upsertHome(@NotNull String name, @NotNull String createdAt, @NotNull String ownerUuid, @NotNull PositionDTO positionDTO) {
        Optional<HomeDTO> existingHomeOpt = this.getHomeByNameAndOwner(name, ownerUuid);
        if (existingHomeOpt.isPresent()) {
            try {
                positionsCrudManager.deletePositionById(positionDTO.id());
                this.deleteHomeByNameAndOwner(name, ownerUuid);
            }
            catch (Exception e) {
                throw new RuntimeException("Error deleting existing home for upsert", e);
            }
        }
        positionDTO = positionsCrudManager.createPosition(positionDTO);
        return this.createHome(name, createdAt, ownerUuid, positionDTO);
    }

    /*
     * Exception decompiling
     */
    public Optional<HomeDTO> getHomeById(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Optional<HomeDTO> getHomeByNameAndOwner(@NotNull String name, @NotNull String ownerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<HomeDTO> getHomesForPlayer(@NotNull String ownerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<HomeDTO> scanHomesCenteredAtPosition(@NotNull PositionDTO centerPosition, double radius) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteHomeById(long id) {
        String sql = "DELETE FROM sb_homes WHERE id = ?;";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_homes WHERE id = ?;");){
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting home by id=" + id, e);
        }
    }

    public void deleteHomeByNameAndOwner(@NotNull String name, @NotNull String ownerUuid) {
        name = HomesCrudManager.strReformat(name);
        String sql = "DELETE FROM sb_homes WHERE name = ? AND owner_uuid = ?;";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_homes WHERE name = ? AND owner_uuid = ?;");){
            ps.setString(1, name);
            ps.setString(2, ownerUuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting home by name=" + name + " and ownerUuid=" + ownerUuid, e);
        }
    }
}

