/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.library.PlayerDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class PlayersCrudManager {
    private final DatabaseManager db;

    public PlayersCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
    }

    private PlayerDTO mapPlayer(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("rs is null");
        }
        @NotNull String uuid = rs.getString("uuid");
        if (uuid == null) {
            throw new IllegalStateException("uuid is null");
        }
        @NotNull String name = rs.getString("name");
        if (name == null) {
            throw new IllegalStateException("name is null");
        }
        @NotNull String firstSeen = rs.getString("first_seen");
        if (firstSeen == null) {
            throw new IllegalStateException("first_seen is null");
        }
        @NotNull String lastSeen = rs.getString("last_seen");
        if (lastSeen == null) {
            throw new IllegalStateException("last_seen is null");
        }
        int playtimeSeconds = rs.getInt("playtime_seconds");
        if (rs.wasNull()) {
            throw new IllegalStateException("playtime_seconds is null");
        }
        boolean canBeIgnored = rs.getInt("can_be_ignored") == 1;
        String nickname = rs.getString("nickname");
        long lastSeenPositionId = rs.getLong("last_seen_position_id");
        Long lastSeenPositionIdNullable = rs.wasNull() ? null : Long.valueOf(lastSeenPositionId);
        return new PlayerDTO(uuid, name, firstSeen, lastSeen, playtimeSeconds, canBeIgnored, nickname, lastSeenPositionIdNullable);
    }

    public PlayerDTO createPlayer(@NotNull String uuid, @NotNull String name, @NotNull String firstSeen, @NotNull String lastSeen, long playtimeSeconds, boolean canBeIgnored, String nickname, Long lastSeenPositionId) {
        String sql = "INSERT INTO sb_players (uuid, name, first_seen, last_seen, playtime_seconds, can_be_ignored, nickname, last_seen_position_id)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?)\n";
        try (PreparedStatement ps = this.db.getConnection().prepareStatement("INSERT INTO sb_players (uuid, name, first_seen, last_seen, playtime_seconds, can_be_ignored, nickname, last_seen_position_id)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?)\n");){
            ps.setString(1, uuid);
            ps.setString(2, name);
            ps.setString(3, firstSeen);
            ps.setString(4, lastSeen);
            ps.setLong(5, playtimeSeconds);
            ps.setInt(6, canBeIgnored ? 1 : 0);
            if (nickname != null) {
                ps.setString(7, nickname);
            } else {
                ps.setNull(7, 12);
            }
            if (lastSeenPositionId != null) {
                ps.setLong(8, lastSeenPositionId);
            } else {
                ps.setNull(8, -5);
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create player", e);
        }
        return this.getPlayerByUuid(uuid).orElseThrow(() -> new IllegalStateException("Failed to retrieve created player with uuid " + uuid));
    }

    public PlayerDTO createPlayer(PlayerDTO playerDTO) throws SQLException {
        return this.createPlayer(playerDTO.uuid(), playerDTO.name(), playerDTO.firstSeen(), playerDTO.lastSeen(), playerDTO.playtimeSeconds(), playerDTO.canBeIgnored(), playerDTO.nickname(), playerDTO.lastSeenPositionId());
    }

    public PlayerDTO upsertPlayer(@NotNull PlayerDTO p) {
        String sql = "INSERT INTO sb_players (uuid, name, first_seen, last_seen, playtime_seconds, can_be_ignored, nickname, last_seen_position_id)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(uuid) DO UPDATE SET\n  name = excluded.name,\n  first_seen = excluded.first_seen,\n  last_seen = excluded.last_seen,\n  playtime_seconds = excluded.playtime_seconds,\n  can_be_ignored = excluded.can_be_ignored,\n  nickname = excluded.nickname,\n  last_seen_position_id = excluded.last_seen_position_id\n";
        try (Connection conn = this.db.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO sb_players (uuid, name, first_seen, last_seen, playtime_seconds, can_be_ignored, nickname, last_seen_position_id)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(uuid) DO UPDATE SET\n  name = excluded.name,\n  first_seen = excluded.first_seen,\n  last_seen = excluded.last_seen,\n  playtime_seconds = excluded.playtime_seconds,\n  can_be_ignored = excluded.can_be_ignored,\n  nickname = excluded.nickname,\n  last_seen_position_id = excluded.last_seen_position_id\n");){
            stmt.setString(1, p.uuid());
            stmt.setString(2, p.name());
            stmt.setString(3, p.firstSeen());
            stmt.setString(4, p.lastSeen());
            stmt.setLong(5, p.playtimeSeconds());
            stmt.setInt(6, p.canBeIgnored() ? 1 : 0);
            if (p.nickname() != null) {
                stmt.setString(7, p.nickname());
            } else {
                stmt.setNull(7, 12);
            }
            if (p.lastSeenPositionId() != null) {
                stmt.setLong(8, p.lastSeenPositionId());
            } else {
                stmt.setNull(8, -5);
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to upsert player " + p.uuid(), e);
        }
        return this.getPlayerByUuid(p.uuid()).orElseThrow(() -> new IllegalStateException("Failed to fetch upserted player " + p.uuid()));
    }

    /*
     * Exception decompiling
     */
    public Optional<PlayerDTO> getPlayerByUuid(@NotNull String uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Optional<PlayerDTO> getPlayerByName(@NotNull String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<PlayerDTO> getAllPlayers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<PlayerDTO> getAllPlayersPaged(int limit, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<PlayerDTO> getPlayersByNameLike(@NotNull String pattern, int limit, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<PlayerDTO> getPlayersByLastSeenPositionId(long positionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean existsPlayer(@NotNull String uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long countPlayers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean hasAnyPlayers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<PlayerDTO> updatePlayer(@NotNull String uuid, @NotNull PlayerDTO updatedPlayer) {
        String sql = "UPDATE sb_players\nSET name = ?, first_seen = ?, last_seen = ?, playtime_seconds = ?, can_be_ignored = ?, nickname = ?, last_seen_position_id = ?\nWHERE uuid = ?\n";
        try (Connection conn = this.db.getConnection();){
            Optional<PlayerDTO> optional;
            block22: {
                PreparedStatement stmt;
                block20: {
                    Optional<PlayerDTO> optional2;
                    block21: {
                        stmt = conn.prepareStatement("UPDATE sb_players\nSET name = ?, first_seen = ?, last_seen = ?, playtime_seconds = ?, can_be_ignored = ?, nickname = ?, last_seen_position_id = ?\nWHERE uuid = ?\n");
                        try {
                            stmt.setString(1, updatedPlayer.name());
                            stmt.setString(2, updatedPlayer.firstSeen());
                            stmt.setString(3, updatedPlayer.lastSeen());
                            stmt.setLong(4, updatedPlayer.playtimeSeconds());
                            stmt.setInt(5, updatedPlayer.canBeIgnored() ? 1 : 0);
                            if (updatedPlayer.nickname() != null) {
                                stmt.setString(6, updatedPlayer.nickname());
                            } else {
                                stmt.setNull(6, 12);
                            }
                            if (updatedPlayer.lastSeenPositionId() != null) {
                                stmt.setLong(7, updatedPlayer.lastSeenPositionId());
                            } else {
                                stmt.setNull(7, -5);
                            }
                            stmt.setString(8, uuid);
                            int affectedRows = stmt.executeUpdate();
                            if (affectedRows != 0) break block20;
                            optional2 = Optional.empty();
                            if (stmt == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = this.getPlayerByUuid(uuid);
                if (stmt == null) break block22;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update player with uuid " + uuid, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<PlayerDTO> incrementPlaytimeSeconds(@NotNull String uuid, long delta) {
        String sql = "UPDATE sb_players SET playtime_seconds = playtime_seconds + ? WHERE uuid = ?";
        try (Connection conn = this.db.getConnection();){
            Optional<PlayerDTO> optional;
            block18: {
                PreparedStatement stmt;
                block16: {
                    Optional<PlayerDTO> optional2;
                    block17: {
                        stmt = conn.prepareStatement("UPDATE sb_players SET playtime_seconds = playtime_seconds + ? WHERE uuid = ?");
                        try {
                            stmt.setLong(1, delta);
                            stmt.setString(2, uuid);
                            if (stmt.executeUpdate() != 0) break block16;
                            optional2 = Optional.empty();
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = this.getPlayerByUuid(uuid);
                if (stmt == null) break block18;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to increment playtime for uuid " + uuid, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<PlayerDTO> touchLastSeenNow(@NotNull String uuid) {
        String sql = "UPDATE sb_players SET last_seen = datetime('now') WHERE uuid = ?";
        try (Connection conn = this.db.getConnection();){
            Optional<PlayerDTO> optional;
            block18: {
                PreparedStatement stmt;
                block16: {
                    Optional<PlayerDTO> optional2;
                    block17: {
                        stmt = conn.prepareStatement("UPDATE sb_players SET last_seen = datetime('now') WHERE uuid = ?");
                        try {
                            stmt.setString(1, uuid);
                            if (stmt.executeUpdate() != 0) break block16;
                            optional2 = Optional.empty();
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = this.getPlayerByUuid(uuid);
                if (stmt == null) break block18;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to touch last_seen for uuid " + uuid, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<PlayerDTO> setNickname(@NotNull String uuid, String nickname) {
        String sql = "UPDATE sb_players SET nickname = ? WHERE uuid = ?";
        try (Connection conn = this.db.getConnection();){
            Optional<PlayerDTO> optional;
            block20: {
                PreparedStatement stmt;
                block18: {
                    Optional<PlayerDTO> optional2;
                    block19: {
                        stmt = conn.prepareStatement("UPDATE sb_players SET nickname = ? WHERE uuid = ?");
                        try {
                            if (nickname != null) {
                                stmt.setString(1, nickname);
                            } else {
                                stmt.setNull(1, 12);
                            }
                            stmt.setString(2, uuid);
                            if (stmt.executeUpdate() != 0) break block18;
                            optional2 = Optional.empty();
                            if (stmt == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = this.getPlayerByUuid(uuid);
                if (stmt == null) break block20;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set nickname for uuid " + uuid, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<PlayerDTO> setLastSeenPosition(@NotNull String uuid, Long positionId) {
        String sql = "UPDATE sb_players SET last_seen_position_id = ? WHERE uuid = ?";
        try (Connection conn = this.db.getConnection();){
            Optional<PlayerDTO> optional;
            block20: {
                PreparedStatement stmt;
                block18: {
                    Optional<PlayerDTO> optional2;
                    block19: {
                        stmt = conn.prepareStatement("UPDATE sb_players SET last_seen_position_id = ? WHERE uuid = ?");
                        try {
                            if (positionId != null) {
                                stmt.setLong(1, positionId);
                            } else {
                                stmt.setNull(1, -5);
                            }
                            stmt.setString(2, uuid);
                            if (stmt.executeUpdate() != 0) break block18;
                            optional2 = Optional.empty();
                            if (stmt == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = this.getPlayerByUuid(uuid);
                if (stmt == null) break block20;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set last_seen_position_id for uuid " + uuid, e);
        }
    }

    public void deletePlayerByUuid(@NotNull String uuid) {
        Optional<PlayerDTO> playerToDelete = this.getPlayerByUuid(uuid);
        if (playerToDelete.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM sb_players\nWHERE uuid = ?\n";
        try (Connection conn = this.db.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM sb_players\nWHERE uuid = ?\n");){
            stmt.setString(1, uuid);
            int affectedRows = stmt.executeUpdate();
            if (affectedRows == 0) {
                throw new RuntimeException("No lines deleted for uuid " + uuid);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete player with uuid " + uuid, e);
        }
    }
}

