/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.library.PositionDTO;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class PositionsCrudManager {
    private final DatabaseManager db;

    public PositionsCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
    }

    private static PositionDTO mapPosition(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("ResultSet cannot be null");
        }
        if (rs.getString("dimension_id") == null) {
            throw new IllegalStateException("dimension_id cannot be null in sb_positions");
        }
        Long id = rs.getLong("id");
        String dimensionId = rs.getString("dimension_id");
        double x = rs.getDouble("x");
        double y = rs.getDouble("y");
        double z = rs.getDouble("z");
        float yRot = rs.getFloat("orientation_yRotation");
        float xRot = rs.getFloat("orientation_xRotation");
        return new PositionDTO(id, dimensionId, x, y, z, yRot, xRot);
    }

    public PositionDTO createPosition(@NotNull String dimensionId, double x, double y, double z, float yRot, float xRot) {
        long id;
        String sql = "INSERT INTO sb_positions (dimension_id, x, y, z, orientation_yRotation, orientation_xRotation)\nVALUES (?, ?, ?, ?, ?, ?)\n";
        try (Connection conn = this.db.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO sb_positions (dimension_id, x, y, z, orientation_yRotation, orientation_xRotation)\nVALUES (?, ?, ?, ?, ?, ?)\n", 1);){
            stmt.setString(1, dimensionId);
            stmt.setDouble(2, x);
            stmt.setDouble(3, y);
            stmt.setDouble(4, z);
            stmt.setFloat(5, yRot);
            stmt.setFloat(6, xRot);
            int affected = stmt.executeUpdate();
            if (affected == 0) {
                throw new RuntimeException("Creating position failed, no rows affected.");
            }
            try (ResultSet keys = stmt.getGeneratedKeys();){
                if (!keys.next()) {
                    throw new RuntimeException("No generated key");
                }
                id = keys.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error creating position", e);
        }
        return this.getPositionById(id).orElseThrow(() -> new RuntimeException("Created position not found with id: " + id));
    }

    public PositionDTO createPosition(PositionDTO position) {
        return this.createPosition(position.dimensionId(), position.x(), position.y(), position.z(), position.yRot(), position.xRot());
    }

    /*
     * Exception decompiling
     */
    public Optional<PositionDTO> getPositionById(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<PositionDTO> getAllPositions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<PositionDTO> getAllPositionsPaged(int limit, int offset) {
        String sql = "SELECT dimension_id, x, y, z, orientation_yRotation, orientation_xRotation\nFROM sb_positions\nORDER BY id ASC\nLIMIT ? OFFSET ?\n";
        ArrayList<PositionDTO> out = new ArrayList<PositionDTO>();
        try (Connection conn = this.db.getConnection();){
            ArrayList<PositionDTO> arrayList;
            block22: {
                PreparedStatement stmt = conn.prepareStatement("SELECT dimension_id, x, y, z, orientation_yRotation, orientation_xRotation\nFROM sb_positions\nORDER BY id ASC\nLIMIT ? OFFSET ?\n");
                try {
                    stmt.setInt(1, limit);
                    stmt.setInt(2, offset);
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            out.add(PositionsCrudManager.mapPosition(rs));
                        }
                    }
                    arrayList = out;
                    if (stmt == null) break block22;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing positions paged", e);
        }
    }

    public Optional<PositionDTO> updatePosition(long id, @NotNull PositionDTO position) {
        Optional<PositionDTO> before = this.getPositionById(id);
        if (before.isEmpty()) {
            return Optional.empty();
        }
        String sql = "UPDATE sb_positions\nSET dimension_id = ?, x = ?, y = ?, z = ?, orientation_yRotation = ?, orientation_xRotation = ?\nWHERE id = ?\n";
        try (Connection conn = this.db.getConnection();
             PreparedStatement stmt = conn.prepareStatement("UPDATE sb_positions\nSET dimension_id = ?, x = ?, y = ?, z = ?, orientation_yRotation = ?, orientation_xRotation = ?\nWHERE id = ?\n");){
            stmt.setString(1, position.dimensionId());
            stmt.setDouble(2, position.x());
            stmt.setDouble(3, position.y());
            stmt.setDouble(4, position.z());
            stmt.setFloat(5, position.yRot());
            stmt.setFloat(6, position.xRot());
            stmt.setLong(7, id);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error updating position id=" + id, e);
        }
        return this.getPositionById(id);
    }

    public void deletePositionById(long id) {
        String sql = "DELETE FROM sb_positions WHERE id = ?";
        Optional<PositionDTO> before = this.getPositionById(id);
        try (Connection conn = this.db.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM sb_positions WHERE id = ?");){
            stmt.setLong(1, id);
            int affected = stmt.executeUpdate();
            if (affected == 0) {
                throw new RuntimeException("No position deleted for id: " + id);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting position id=" + id, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int deleteUnusedPositions() {
        try (Connection conn = this.db.getConnection();){
            int n;
            block25: {
                DatabaseMetaData meta = conn.getMetaData();
                ArrayList<AbstractMap.SimpleEntry<String, String>> refs = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                try (ResultSet fkRs = meta.getExportedKeys(conn.getCatalog(), null, "sb_positions");){
                    while (fkRs.next()) {
                        String fkTable = fkRs.getString("FKTABLE_NAME");
                        String fkColumn = fkRs.getString("FKCOLUMN_NAME");
                        if (fkTable == null || fkColumn == null) continue;
                        refs.add(new AbstractMap.SimpleEntry<String, String>(fkTable, fkColumn));
                    }
                }
                StringBuilder sql = new StringBuilder("DELETE FROM sb_positions");
                if (!refs.isEmpty()) {
                    sql.append(" WHERE ");
                    for (int i = 0; i < refs.size(); ++i) {
                        if (i > 0) {
                            sql.append(" AND ");
                        }
                        String alias = "t" + i;
                        sql.append("NOT EXISTS (SELECT 1 FROM ").append((String)((Map.Entry)refs.get(i)).getKey()).append(" ").append(alias).append(" WHERE ").append(alias).append(".").append((String)((Map.Entry)refs.get(i)).getValue()).append(" = sb_positions.id)");
                    }
                }
                PreparedStatement stmt = conn.prepareStatement(sql.toString());
                try {
                    n = stmt.executeUpdate();
                    if (stmt == null) break block25;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting unused positions", e);
        }
    }
}

