/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.core.db.PositionsCrudManager;
import as.sirhephaistos.simplybetter.library.PositionDTO;
import as.sirhephaistos.simplybetter.library.WarpDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WarpsCrudManager {
    private final DatabaseManager db;
    private static PositionsCrudManager positionsCrudManager;

    public WarpsCrudManager(DatabaseManager db, PositionsCrudManager positionsCrudManager) {
        this.db = db;
        WarpsCrudManager.positionsCrudManager = positionsCrudManager;
    }

    private static WarpDTO mapWarp(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("rs is null");
        }
        long id = rs.getLong("id");
        if (rs.wasNull()) {
            throw new IllegalStateException("id is null");
        }
        @NotNull String name = rs.getString("name");
        if (name == null) {
            throw new IllegalStateException("name is null");
        }
        long positionId = rs.getLong("position_id");
        if (rs.wasNull()) {
            throw new IllegalStateException("position_id is null");
        }
        @Nullable String createdBy = rs.getString("created_by_uuid");
        @NotNull String createdAt = rs.getString("created_at");
        if (createdAt == null) {
            throw new IllegalStateException("created_at is null");
        }
        @NotNull PositionDTO position = positionsCrudManager.getPositionById(positionId).orElseThrow(() -> new IllegalStateException("position with id " + positionId + " does not exist"));
        return new WarpDTO(id, name, position, createdBy, createdAt);
    }

    private static String strReformat(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String is null");
        }
        return s.replaceAll("[^a-zA-Z0-9_]", "").replace(" ", "_").toLowerCase();
    }

    public WarpDTO createWarp(@NotNull String name, @NotNull PositionDTO positionDTO, @Nullable String createdBy, @Nullable String createdAt) {
        long id;
        name = WarpsCrudManager.strReformat(name);
        if (positionDTO.id() == null && (positionDTO = positionsCrudManager.createPosition(positionDTO)).id() == null) {
            throw new IllegalStateException("Failed to create position for warp");
        }
        String sql = "INSERT INTO sb_warps (name,  created_at, created_by_uuid, position_id) VALUES (?, ?, ?, ?)";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, name);
            if (createdAt != null) {
                ps.setString(2, createdAt);
            } else {
                ps.setString(2, Instant.now().toString());
            }
            if (createdBy != null) {
                ps.setString(3, createdBy);
            } else {
                ps.setNull(3, 12);
            }
            ps.setLong(4, positionDTO.id());
            ps.executeUpdate();
            try (ResultSet keys = ps.getGeneratedKeys();){
                if (!keys.next()) {
                    throw new RuntimeException("No generated keys");
                }
                id = keys.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create warp", e);
        }
        return this.getWarpById(id).orElseThrow(() -> new IllegalStateException("Failed to retrieve created warp with id " + id));
    }

    public WarpDTO createWarp(@NotNull String name, long idPosition, @Nullable String createdBy, @NotNull String createdAt) {
        PositionDTO positionDTO = positionsCrudManager.getPositionById(idPosition).orElseThrow(() -> new IllegalArgumentException("Position with id " + idPosition + " does not exist"));
        return this.createWarp(name, positionDTO, createdBy, createdAt);
    }

    public WarpDTO createWarp(@NotNull String name, @NotNull PositionDTO positionDTO) {
        return this.createWarp(name, positionDTO, null, null);
    }

    public WarpDTO createWarp(@NotNull String name, long idPosition) {
        PositionDTO positionDTO = positionsCrudManager.getPositionById(idPosition).orElseThrow(() -> new IllegalArgumentException("Position with id " + idPosition + " does not exist"));
        return this.createWarp(name, positionDTO, null, null);
    }

    /*
     * Exception decompiling
     */
    public Optional<WarpDTO> getWarpById(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Optional<WarpDTO> getWarpByName(@NotNull String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<WarpDTO> getAllWarps() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<WarpDTO> getAllWarpsPaged(int limit, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<String, @NotNull Long> getWarpsMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<String, @NotNull Long> getWarpsMapPaged(int limit, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, @NotNull Long> getStringLongMap(ResultSet rs) throws SQLException {
        HashMap<String, Long> warpsMap = new HashMap<String, Long>();
        while (rs.next()) {
            long id = rs.getLong("id");
            if (rs.wasNull()) {
                throw new IllegalStateException("id is null");
            }
            @NotNull String name = rs.getString("name");
            if (name == null) {
                throw new IllegalStateException("name is null");
            }
            warpsMap.put(name, id);
        }
        return warpsMap;
    }

    public Optional<WarpDTO> updateWarpPosition(long warpId, @NotNull PositionDTO newPosition) {
        Optional<WarpDTO> existingWarpOpt = this.getWarpById(warpId);
        if (existingWarpOpt.isEmpty()) {
            return Optional.empty();
        }
        WarpDTO existingWarp = existingWarpOpt.get();
        PositionDTO positionToUpdate = newPosition.id() == null ? positionsCrudManager.createPosition(newPosition) : newPosition;
        String sql = "UPDATE sb_warps SET position_id = ? WHERE id = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("UPDATE sb_warps SET position_id = ? WHERE id = ?");){
            ps.setLong(1, positionToUpdate.id());
            ps.setLong(2, warpId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update warp position for warp id=" + warpId, e);
        }
        return this.getWarpById(warpId);
    }

    public Optional<WarpDTO> renameWarp(long warpId, @NotNull String newName) {
        if (this.getWarpById(warpId).isEmpty()) {
            throw new IllegalArgumentException("Warp with id " + warpId + " does not exist");
        }
        String sql = "UPDATE sb_warps SET name = ? WHERE id = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("UPDATE sb_warps SET name = ? WHERE id = ?");){
            ps.setString(1, newName);
            ps.setLong(2, warpId);
            int executed = ps.executeUpdate();
            if (executed == 0) {
                throw new IllegalStateException("No warp renamed with id " + warpId);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to rename warp id=" + warpId, e);
        }
        return this.getWarpById(warpId);
    }

    public void deleteWarpById(long id) {
        if (this.getWarpById(id).isEmpty()) {
            throw new IllegalArgumentException("Warp with id " + id + " does not exist");
        }
        String sql = "DELETE FROM sb_warps WHERE id = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_warps WHERE id = ?");){
            ps.setLong(1, id);
            int affected = ps.executeUpdate();
            if (affected == 0) {
                throw new IllegalStateException("No warp deleted with id " + id);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete warp by id=" + id, e);
        }
    }

    public void deleteWarpByName(@NotNull String name) {
        Optional<WarpDTO> warpOpt = this.getWarpByName(name = WarpsCrudManager.strReformat(name));
        if (warpOpt.isEmpty()) {
            throw new IllegalArgumentException("Warp with name " + name + " does not exist");
        }
        String sql = "DELETE FROM sb_warps WHERE name = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_warps WHERE name = ?");){
            ps.setString(1, name);
            int affected = ps.executeUpdate();
            if (affected == 0) {
                throw new IllegalStateException("No warp deleted with name " + name);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete warp by name=" + name, e);
        }
    }
}

