/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.simplybetter.core.db;

import as.sirhephaistos.simplybetter.core.db.DatabaseManager;
import as.sirhephaistos.simplybetter.library.WorldDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldsCrudManager {
    private final DatabaseManager db;

    public WorldsCrudManager(@NotNull DatabaseManager db) {
        this.db = db;
    }

    private static WorldDTO mapWorld(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("ResultSet cannot be null");
        }
        if (rs.getLong("id") == 0L) {
            throw new IllegalStateException("ID cannot be null");
        }
        if (rs.getString("dimension_id") == null) {
            throw new IllegalStateException("Dimension ID cannot be null");
        }
        long id = rs.getLong("id");
        String dimensionId = rs.getString("dimension_id");
        Long centerPositionId = rs.getLong("center_position_id") == 0L ? null : Long.valueOf(rs.getLong("center_position_id"));
        return new WorldDTO(id, dimensionId, centerPositionId);
    }

    public WorldDTO createWorld(@NotNull String dimensionId, @Nullable Long centerPositionId) {
        long id;
        if (this.getWorldByDimensionId(dimensionId).isPresent()) {
            throw new IllegalArgumentException("World with dimension_id=" + dimensionId + " already exists");
        }
        String sql = "INSERT INTO sb_worlds (dimension_id, center_position_id)\nVALUES (?, ?)\n";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("INSERT INTO sb_worlds (dimension_id, center_position_id)\nVALUES (?, ?)\n", 1);){
            ps.setString(1, dimensionId);
            if (centerPositionId == null) {
                ps.setNull(2, -5);
            } else {
                ps.setLong(2, centerPositionId);
            }
            ps.executeUpdate();
            try (ResultSet keys = ps.getGeneratedKeys();){
                if (!keys.next()) {
                    throw new RuntimeException("No generated key");
                }
                id = keys.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error inserting world for dimension=" + dimensionId, e);
        }
        return this.getWorldById(id).orElseThrow(() -> new RuntimeException("Error fetching newly created world with id=" + id));
    }

    /*
     * Exception decompiling
     */
    public Optional<WorldDTO> getWorldById(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Optional<WorldDTO> getWorldByDimensionId(@NotNull String dimensionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<WorldDTO> getAllWorlds() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<WorldDTO> getAllWorldsPaged(int limit, int offset) {
        String sql = "SELECT id, dimension_id, center_position_id\nFROM sb_worlds\nORDER BY id ASC\nLIMIT ? OFFSET ?\n";
        ArrayList<WorldDTO> out = new ArrayList<WorldDTO>();
        try (Connection conn = this.db.getConnection();){
            ArrayList<WorldDTO> arrayList;
            block22: {
                PreparedStatement ps = conn.prepareStatement("SELECT id, dimension_id, center_position_id\nFROM sb_worlds\nORDER BY id ASC\nLIMIT ? OFFSET ?\n");
                try {
                    ps.setInt(1, limit);
                    ps.setInt(2, offset);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            out.add(WorldsCrudManager.mapWorld(rs));
                        }
                    }
                    arrayList = out;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing paged worlds", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<WorldDTO> renameWorldById(long id, @NotNull String newDimensionId) {
        Optional<WorldDTO> before = this.getWorldById(id);
        if (before.isEmpty()) {
            return Optional.empty();
        }
        String sql = "UPDATE sb_worlds\nSET dimension_id = ?\nWHERE id = ?\n";
        try (Connection conn = this.db.getConnection();){
            Optional<WorldDTO> optional;
            block16: {
                PreparedStatement ps = conn.prepareStatement("UPDATE sb_worlds\nSET dimension_id = ?\nWHERE id = ?\n");
                try {
                    ps.setString(1, newDimensionId);
                    ps.setLong(2, id);
                    int affected = ps.executeUpdate();
                    if (affected == 0) {
                        throw new RuntimeException("No world updated for id=" + id);
                    }
                    optional = this.getWorldById(id);
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error renaming world id=" + id, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<WorldDTO> renameWorldByDimensionId(@NotNull String currentDimensionId, @NotNull String newDimensionId) {
        Optional<WorldDTO> before = this.getWorldByDimensionId(currentDimensionId);
        if (before.isEmpty()) {
            return Optional.empty();
        }
        String sql = "UPDATE sb_worlds\nSET dimension_id = ?\nWHERE dimension_id = ?\n";
        try (Connection conn = this.db.getConnection();){
            Optional<WorldDTO> optional;
            block16: {
                PreparedStatement ps = conn.prepareStatement("UPDATE sb_worlds\nSET dimension_id = ?\nWHERE dimension_id = ?\n");
                try {
                    ps.setString(1, newDimensionId);
                    ps.setString(2, currentDimensionId);
                    int affected = ps.executeUpdate();
                    if (affected == 0) {
                        throw new RuntimeException("No world updated for dimension_id=" + currentDimensionId);
                    }
                    optional = this.getWorldByDimensionId(newDimensionId);
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error renaming world dimension_id=" + currentDimensionId, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<WorldDTO> updateCenterPositionById(long id, @Nullable Long newCenterPositionId) {
        Optional<WorldDTO> before = this.getWorldById(id);
        if (before.isEmpty()) {
            return Optional.empty();
        }
        String sql = "UPDATE sb_worlds\nSET center_position_id = ?\nWHERE id = ?\n";
        try (Connection conn = this.db.getConnection();){
            Optional<WorldDTO> optional;
            block18: {
                PreparedStatement ps = conn.prepareStatement("UPDATE sb_worlds\nSET center_position_id = ?\nWHERE id = ?\n");
                try {
                    if (newCenterPositionId == null) {
                        ps.setNull(1, -5);
                    } else {
                        ps.setLong(1, newCenterPositionId);
                    }
                    ps.setLong(2, id);
                    int affected = ps.executeUpdate();
                    if (affected == 0) {
                        throw new RuntimeException("No world updated for id=" + id);
                    }
                    optional = this.getWorldById(id);
                    if (ps == null) break block18;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error updating center_position_id for world id=" + id, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<WorldDTO> updateCenterPositionByDimensionId(@NotNull String dimensionId, @Nullable Long newCenterPositionId) {
        Optional<WorldDTO> before = this.getWorldByDimensionId(dimensionId);
        if (before.isEmpty()) {
            return Optional.empty();
        }
        String sql = "UPDATE sb_worlds\nSET center_position_id = ?\nWHERE dimension_id = ?\n";
        try (Connection conn = this.db.getConnection();){
            Optional<WorldDTO> optional;
            block18: {
                PreparedStatement ps = conn.prepareStatement("UPDATE sb_worlds\nSET center_position_id = ?\nWHERE dimension_id = ?\n");
                try {
                    if (newCenterPositionId == null) {
                        ps.setNull(1, -5);
                    } else {
                        ps.setLong(1, newCenterPositionId);
                    }
                    ps.setString(2, dimensionId);
                    int affected = ps.executeUpdate();
                    if (affected == 0) {
                        throw new RuntimeException("No world updated for dimension_id=" + dimensionId);
                    }
                    optional = this.getWorldByDimensionId(dimensionId);
                    if (ps == null) break block18;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error updating center_position_id for world dimension_id=" + dimensionId, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<WorldDTO> deleteWorldById(long id) {
        Optional<WorldDTO> before = this.getWorldById(id);
        if (before.isEmpty()) {
            return Optional.empty();
        }
        String sql = "DELETE FROM sb_worlds WHERE id = ?";
        try (Connection conn = this.db.getConnection();){
            Optional<WorldDTO> optional;
            block16: {
                PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_worlds WHERE id = ?");
                try {
                    ps.setLong(1, id);
                    int affected = ps.executeUpdate();
                    if (affected == 0) {
                        throw new RuntimeException("No world deleted for id=" + id);
                    }
                    optional = before;
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting world id=" + id, e);
        }
    }

    public void deleteWorldByDimensionId(@NotNull String dimensionId) {
        if (this.getWorldByDimensionId(dimensionId).isPresent()) {
            throw new IllegalArgumentException("World with dimension_id=" + dimensionId + " does not exist");
        }
        String sql = "DELETE FROM sb_worlds WHERE dimension_id = ?";
        try (Connection conn = this.db.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM sb_worlds WHERE dimension_id = ?");){
            ps.setString(1, dimensionId);
            ps.executeUpdate();
            if (ps.getUpdateCount() == 0) {
                throw new RuntimeException("No world deleted for dimension_id=" + dimensionId);
            }
            if (this.getWorldByDimensionId(dimensionId).isPresent()) {
                throw new RuntimeException("World with dimension_id=" + dimensionId + " still exists after deletion");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting world dimension_id=" + dimensionId, e);
        }
    }
}

