/*
 * Decompiled with CFR 0.152.
 */
package as.sirhephaistos.util;

import as.sirhephaistos.simplybetter.library.PositionDTO;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TeleportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"simplybetter-teleport");

    private TeleportUtils() {
    }

    public static int teleportPlayerToPosition(class_3222 player, PositionDTO position, String errorMessage, String successMessage, class_2168 src) {
        try {
            class_2960 dimId = class_2960.method_12829((String)position.dimensionId());
            if (dimId == null) {
                LOGGER.error("Invalid dimension ID: {}", (Object)position.dimensionId());
                class_5250 text = class_2561.method_43470((String)errorMessage).method_10852((class_2561)class_2561.method_43470((String)"'. Invalid dimension."));
                src.method_9213((class_2561)text);
                return 0;
            }
            class_5321 targetKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimId);
            class_3218 targetWorld = Objects.requireNonNull(player.method_5682()).method_3847(targetKey);
            if (targetWorld == null) {
                LOGGER.error("Target world is null for dimension: {}", (Object)dimId);
                class_5250 text = class_2561.method_43470((String)errorMessage).method_10852((class_2561)class_2561.method_43470((String)"'. World not found."));
                src.method_9213((class_2561)text);
                return 0;
            }
            class_2338 targetPos = class_2338.method_49637((double)position.x(), (double)position.y(), (double)position.z());
            class_1923 chunkPos = new class_1923(targetPos);
            targetWorld.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)player.method_5628());
            targetWorld.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            player.method_14251(targetWorld, position.x(), position.y(), position.z(), position.yRot(), position.xRot());
            class_5250 text = class_2561.method_43470((String)successMessage);
            src.method_9226(() -> text, false);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Failed to teleport player to position: {}", (Object)position, (Object)e);
            class_5250 text = class_2561.method_43470((String)errorMessage).method_10852((class_2561)class_2561.method_43470((String)"'. Please try again later."));
            src.method_9213((class_2561)text);
            return 0;
        }
    }
}

