/*
 * Decompiled with CFR 0.152.
 */
package hu.qliqs;

import com.mojang.logging.LogUtils;
import com.simibubi.create.Create;
import hu.qliqs.MessageMaker;
import hu.qliqs.TramAdditions;
import hu.qliqs.Utils;
import hu.qliqs.WsClient;
import hu.qliqs.mixin_interfaces.TrainACInterface;
import java.net.URI;
import java.util.ArrayList;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.java_websocket.exceptions.WebsocketNotConnectedException;

public class WorldTick {
    private static int tickCounter = 0;
    private static int reconnectCounter = 0;

    public static void onWorldTick(MinecraftServer server) {
        block3: {
            if (++tickCounter >= 20) {
                tickCounter = 0;
                class_3218 world = server.method_30002();
                long dayTime = world.method_8532();
                long normalizedTime = (dayTime + 6000L) % 24000L;
                int hours = (int)(normalizedTime / 1000L);
                int minutes = (int)(normalizedTime % 1000L * 60L / 1000L);
                String mcTime = String.format("%02d:%02d", hours, minutes);
                try {
                    TramAdditions.wsclient.send("SEND|ALL|false|TIME;%s".formatted(mcTime));
                }
                catch (WebsocketNotConnectedException e) {
                    System.out.println("The server isn't connected to the proxy.");
                    if (++reconnectCounter <= 5) break block3;
                    reconnectCounter = 0;
                    TramAdditions.userPinMap.clear();
                    TramAdditions.wsclient = new WsClient(URI.create("wss://neebooo.is-a.dev/ws"));
                }
            }
        }
        Create.RAILWAYS.trains.values().forEach(train -> {
            TrainACInterface trainACI;
            if (!TramAdditions.hasAnnouncedNextStation.containsKey(train.id)) {
                TramAdditions.hasAnnouncedNextStation.put(train.id, false);
            }
            if (!TramAdditions.hasAnnouncedCurrentStation.containsKey(train.id)) {
                TramAdditions.hasAnnouncedCurrentStation.put(train.id, false);
            }
            try {
                trainACI = (TrainACInterface)train;
            }
            catch (ClassCastException cce) {
                LogUtils.getLogger().error(cce.getMessage());
                return;
            }
            if (train.getCurrentStation() == null && !Utils.isWaypointing(train)) {
                TramAdditions.hasAnnouncedCurrentStation.replace(train.id, false);
                if (train.navigation.destination != null && !TramAdditions.hasAnnouncedNextStation.get(train.id).booleanValue()) {
                    ArrayList playerList = new ArrayList();
                    String msg = MessageMaker.makeMessage(train.navigation.destination.id, train.navigation.destination.name, false, train);
                    if (msg.isEmpty()) {
                        return;
                    }
                    train.carriages.forEach(carriage -> carriage.forEachPresentEntity(entity -> entity.method_5736().forEach(p -> {
                        if (p instanceof class_3222) {
                            playerList.add((class_3222)p);
                        }
                    })));
                    class_3222[] serverPlayers = playerList.toArray(new class_3222[0]);
                    TramAdditions.hasAnnouncedNextStation.replace(train.id, true);
                    Utils.playSoundAsync(msg, trainACI.createTramAdditions$getVoiceRole(), serverPlayers, server);
                }
            } else {
                if (!TramAdditions.hasAnnouncedCurrentStation.get(train.id).booleanValue() && !Utils.isWaypointing(train)) {
                    ArrayList playerList = new ArrayList();
                    String msg = MessageMaker.makeMessage(train.getCurrentStation().id, train.getCurrentStation().name, true, train);
                    if (msg.isEmpty()) {
                        return;
                    }
                    train.carriages.forEach(carriage -> carriage.forEachPresentEntity(entity -> entity.method_5736().forEach(p -> {
                        if (p instanceof class_3222) {
                            playerList.add((class_3222)p);
                        }
                    })));
                    class_3222[] serverPlayers = playerList.toArray(new class_3222[0]);
                    TramAdditions.hasAnnouncedCurrentStation.replace(train.id, true);
                    Utils.playSoundAsync(msg, trainACI.createTramAdditions$getVoiceRole(), serverPlayers, server);
                }
                TramAdditions.hasAnnouncedNextStation.replace(train.id, false);
            }
        });
    }
}

