/*
 * Decompiled with CFR 0.152.
 */
package hu.qliqs.instructions;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Pair;
import dev.architectury.utils.GameInstance;
import hu.qliqs.ICustomExecutableInstruction;
import hu.qliqs.MessageMaker;
import hu.qliqs.Utils;
import hu.qliqs.mixin.AccessorScheduleRuntime;
import hu.qliqs.mixin_interfaces.TrainACInterface;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class AnnounceInstruction
extends ScheduleInstruction
implements ICustomExecutableInstruction {
    public String MsgToAnnounce;

    public AnnounceInstruction() {
        this.data.method_10582("Message", "");
        this.data.method_10569("OmitNextStop", 0);
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addTextInput(0, 101, (si, l) -> si.method_1880(1000), "Message");
        builder.addSelectionScrollInput(102, 35, (si, l) -> {
            l.getToolTip().add(class_2561.method_43470((String)"Omit next stop announcement"));
            si.forOptions(List.of(class_2561.method_43470((String)"True"), class_2561.method_43470((String)"False")));
        }, "OmitNextStop");
    }

    public boolean supportsConditions() {
        return false;
    }

    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)new class_1799((class_1935)class_1802.field_8643), (Object)class_2561.method_43470((String)"Announce Message"));
    }

    public class_2960 getId() {
        return new class_2960("tram_additions", "announcemessage");
    }

    @Override
    public void execute(ScheduleRuntime runtime) {
        String finalMessage = MessageMaker.formatMessage(this.textData("Message"), ((AccessorScheduleRuntime)runtime).getTrain());
        TrainACInterface train = (TrainACInterface)((AccessorScheduleRuntime)runtime).getTrain();
        train.createTramAdditions$setOmitNextStopAnnouncement(this.intData("OmitNextMessage") == 0);
        ArrayList playerList = new ArrayList();
        ((AccessorScheduleRuntime)runtime).getTrain().carriages.forEach(carriage -> carriage.forEachPresentEntity(entity -> entity.method_5736().forEach(p -> {
            if (p instanceof class_3222) {
                playerList.add((class_3222)p);
            }
        })));
        class_3222[] serverPlayers = playerList.toArray(new class_3222[0]);
        Utils.playSoundAsync(finalMessage, train.createTramAdditions$getVoiceRole(), serverPlayers, GameInstance.getServer());
        runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
        ++runtime.currentEntry;
    }

    private String getCurrentStop(Train train) {
        Schedule schedule = train.runtime.getSchedule();
        if (train.getCurrentStation() == null) {
            int startIndex;
            for (int i = startIndex = train.runtime.currentEntry - 1; i >= 0; --i) {
                if (!(((ScheduleEntry)schedule.entries.get((int)i)).instruction instanceof DestinationInstruction)) continue;
                return ((ScheduleEntry)schedule.entries.get((int)i)).instruction.getData().method_10558("Text");
            }
            return "Error";
        }
        return train.getCurrentStation().name;
    }

    public static String getNextStop(Train train) {
        int startIndex;
        int i;
        Schedule schedule = train.runtime.getSchedule();
        for (i = startIndex = train.runtime.currentEntry; i < schedule.entries.size(); ++i) {
            if (!(((ScheduleEntry)schedule.entries.get((int)i)).instruction instanceof DestinationInstruction)) continue;
            return ((ScheduleEntry)schedule.entries.get((int)i)).instruction.getData().method_10558("Text");
        }
        for (i = 0; i < schedule.entries.size(); ++i) {
            if (!(((ScheduleEntry)schedule.entries.get((int)i)).instruction instanceof DestinationInstruction)) continue;
            return ((ScheduleEntry)schedule.entries.get((int)i)).instruction.getData().method_10558("Text");
        }
        return "Nowhere";
    }
}

