/*
 * Decompiled with CFR 0.152.
 */
package hu.qliqs.state;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hu.qliqs.state.FileUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3218;

public class JsonMapStorage {
    private final Gson GSON = new Gson();
    private final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private Map<String, String> map = new HashMap<String, String>();
    private final class_3218 world;

    public JsonMapStorage(class_3218 world) {
        this.world = world;
    }

    public void load(class_3218 world) {
        Path path = FileUtils.getDataFile(world);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String json = Files.readString(path);
                this.map = (Map)this.GSON.fromJson(json, this.MAP_TYPE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        Path path = FileUtils.getDataFile(this.world);
        try {
            String json = this.GSON.toJson(this.map);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void delete() {
        this.map.clear();
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void update(String key, String value) {
        this.map.put(key, value);
        this.save();
    }
}

