/*
 * Decompiled with CFR 0.152.
 */
package hu.qliqs;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import hu.qliqs.instructions.AnnounceInstruction;
import hu.qliqs.mixin_interfaces.TrainACInterface;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;

public class MessageMaker {
    public static String stationNameToTag(String stationName) throws NoClassDefFoundError {
        return GlobalSettings.getInstance().getOrCreateStationTagFor(stationName).getTagName().get();
    }

    public static String uuidToLine(UUID uuid, int scheduleIndex) {
        Optional td = TrainListener.getTrainData((UUID)uuid);
        if (td.isEmpty()) {
            return "Unknown";
        }
        TrainLine trainLine = ((TrainData)td.get()).getTrainInfo(scheduleIndex).line();
        if (trainLine == null) {
            return "Unknown";
        }
        return trainLine.getLineName();
    }

    public static String uuidToGroup(UUID uuid, int scheduleIndex) {
        Optional td = TrainListener.getTrainData((UUID)uuid);
        if (td.isEmpty()) {
            return "Unknown";
        }
        TrainCategory trainGroup = ((TrainData)td.get()).getTrainInfo(scheduleIndex).category();
        if (trainGroup == null) {
            return "Unknown";
        }
        return trainGroup.getCategoryName();
    }

    public static String makeStationName(String stationName) {
        try {
            stationName = MessageMaker.stationNameToTag(stationName);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return stationName;
    }

    public static String formatMessage(String message, Train train) {
        if (train.id == null || train.runtime == null || train.runtime.getSchedule() == null) {
            return message;
        }
        String next_stop = AnnounceInstruction.getNextStop(train);
        message = message.replaceAll(Pattern.quote("${next_stop}"), MessageMaker.makeStationName(next_stop));
        try {
            message = message.replaceAll(Pattern.quote("${line}"), MessageMaker.uuidToLine(train.id, train.runtime.getSchedule().savedProgress));
            message = message.replaceAll(Pattern.quote("${group}"), MessageMaker.uuidToGroup(train.id, train.runtime.getSchedule().savedProgress));
        }
        catch (NoClassDefFoundError | NullPointerException throwable) {
            // empty catch block
        }
        return message;
    }

    public static String makeMessage(UUID stationUUID, String stationName, Boolean arrived, Train train) {
        stationName = MessageMaker.makeStationName(stationName);
        if (arrived.booleanValue()) {
            return "%s.".formatted(stationName);
        }
        TrainACInterface trainAC = (TrainACInterface)train;
        if (trainAC.createTramAdditions$getOmitNextStopAnnouncement()) {
            trainAC.createTramAdditions$setOmitNextStopAnnouncement(false);
            return "";
        }
        return MessageMaker.formatMessage(trainAC.createTramAdditions$getDefaultNextStopAnnouncement(), train);
    }
}

