/*
 * Decompiled with CFR 0.152.
 */
package hu.qliqs;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.dragnsounds.api.ServerApi;
import de.mrjulsen.dragnsounds.core.data.PlaybackConfig;
import de.mrjulsen.dragnsounds.core.ffmpeg.AudioSettings;
import de.mrjulsen.dragnsounds.core.ffmpeg.EChannels;
import hu.qliqs.config.ModServerConfig;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class Utils {
    public static String getAPIEndpoint() {
        return (String)ModServerConfig.TTS_SERVER.get();
    }

    public static void playSoundAsync(String message, String language, ServerPlayer[] players, MinecraftServer server) {
        new Thread(() -> {
            try {
                URL url = new URL(Utils.getAPIEndpoint() + "/?text=" + URLEncoder.encode(message, StandardCharsets.UTF_8) + "&lang=" + URLEncoder.encode(language, StandardCharsets.UTF_8));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                BufferedInputStream in = new BufferedInputStream(con.getInputStream());
                server.execute(() -> {
                    try {
                        ServerApi.playSoundOnce((InputStream)in, (AudioSettings)new AudioSettings(EChannels.STEREO, 64000, 22050, 5), (PlaybackConfig)PlaybackConfig.defaultUI((float)1.0f, (float)1.0f, (int)0), (ServerPlayer[])players, (player, l, status) -> {}, null, result -> System.out.println(result.message()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, "tts-fetch").start();
    }

    public static void registerInstruction(String name, Supplier<? extends ScheduleInstruction> factory) {
        Schedule.INSTRUCTION_TYPES.add(Pair.of((Object)new ResourceLocation("tram_additions", name), factory));
    }

    public static boolean isWaypointing(Train train) {
        if (train == null || train.runtime == null || train.runtime.getSchedule() == null) {
            return false;
        }
        if (train.runtime.getSchedule().entries.size() <= train.runtime.currentEntry) {
            return false;
        }
        return Objects.equals(((ScheduleEntry)train.runtime.getSchedule().entries.get((int)train.runtime.currentEntry)).instruction.getId(), new ResourceLocation("railways", "waypoint_destination"));
    }
}

