/*
 * Decompiled with CFR 0.152.
 */
package hu.qliqs;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.lwjgl.openal.AL10;

public class WavLoader {
    private int source;
    private int buffer;

    public void playWav(InputStream wavInput) {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(wavInput);
            AudioFormat format = ais.getFormat();
            int channels = format.getChannels();
            int sampleRate = (int)format.getSampleRate();
            int alFormat = this.getOpenALFormat(format);
            byte[] pcmData = ais.readAllBytes();
            ByteBuffer data = ByteBuffer.allocateDirect(pcmData.length).order(ByteOrder.nativeOrder());
            data.put(pcmData);
            data.flip();
            this.buffer = AL10.alGenBuffers();
            AL10.alBufferData((int)this.buffer, (int)alFormat, (ByteBuffer)data, (int)sampleRate);
            this.source = AL10.alGenSources();
            AL10.alSourcei((int)this.source, (int)4105, (int)this.buffer);
            AL10.alSourcePlay((int)this.source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getOpenALFormat(AudioFormat format) {
        if (format.getChannels() == 1) {
            return format.getSampleSizeInBits() == 8 ? 4352 : 4353;
        }
        if (format.getChannels() == 2) {
            return format.getSampleSizeInBits() == 8 ? 4354 : 4355;
        }
        throw new IllegalArgumentException("Unsupported WAV format");
    }

    public void cleanup() {
        AL10.alDeleteSources((int)this.source);
        AL10.alDeleteBuffers((int)this.buffer);
    }
}

