/*
 * Decompiled with CFR 0.152.
 */
package hu.qliqs.instructions;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Pair;
import dev.architectury.utils.GameInstance;
import hu.qliqs.ICustomExecutableInstruction;
import hu.qliqs.MessageMaker;
import hu.qliqs.Utils;
import hu.qliqs.mixin.AccessorScheduleRuntime;
import hu.qliqs.mixin_interfaces.TrainACInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AnnounceInstruction
extends ScheduleInstruction
implements ICustomExecutableInstruction {
    public String MsgToAnnounce;

    public AnnounceInstruction() {
        this.data.m_128359_("Message", "");
        this.data.m_128405_("OmitNextStop", 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addTextInput(0, 101, (si, l) -> si.m_94199_(1000), "Message");
        builder.addSelectionScrollInput(102, 35, (si, l) -> {
            l.getToolTip().add(Component.m_237113_((String)"Omit next stop announcement"));
            si.forOptions(List.of(Component.m_237113_((String)"True"), Component.m_237113_((String)"False")));
        }, "OmitNextStop");
    }

    public boolean supportsConditions() {
        return false;
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)new ItemStack((ItemLike)Items.f_41859_), (Object)Component.m_237113_((String)"Announce Message"));
    }

    public ResourceLocation getId() {
        return new ResourceLocation("tram_additions", "announcemessage");
    }

    @Override
    public void execute(ScheduleRuntime runtime) {
        String finalMessage = MessageMaker.formatMessage(this.textData("Message"), ((AccessorScheduleRuntime)runtime).getTrain());
        TrainACInterface train = (TrainACInterface)((AccessorScheduleRuntime)runtime).getTrain();
        train.createTramAdditions$setOmitNextStopAnnouncement(this.intData("OmitNextMessage") == 0);
        ArrayList playerList = new ArrayList();
        ((AccessorScheduleRuntime)runtime).getTrain().carriages.forEach(carriage -> carriage.forEachPresentEntity(entity -> entity.m_146897_().forEach(p -> {
            if (p instanceof ServerPlayer) {
                playerList.add((ServerPlayer)p);
            }
        })));
        ServerPlayer[] serverPlayers = playerList.toArray(new ServerPlayer[0]);
        Utils.playSoundAsync(finalMessage, train.createTramAdditions$getVoiceRole(), serverPlayers, GameInstance.getServer());
        runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
        ++runtime.currentEntry;
    }

    private String getCurrentStop(Train train) {
        Schedule schedule = train.runtime.getSchedule();
        if (train.getCurrentStation() == null) {
            int startIndex;
            for (int i = startIndex = train.runtime.currentEntry - 1; i >= 0; --i) {
                if (!(((ScheduleEntry)schedule.entries.get((int)i)).instruction instanceof DestinationInstruction)) continue;
                return ((ScheduleEntry)schedule.entries.get((int)i)).instruction.getData().m_128461_("Text");
            }
            return "Error";
        }
        return train.getCurrentStation().name;
    }

    public static String getNextStop(Train train) {
        int startIndex;
        int i;
        Schedule schedule = train.runtime.getSchedule();
        for (i = startIndex = train.runtime.currentEntry; i < schedule.entries.size(); ++i) {
            if (!(((ScheduleEntry)schedule.entries.get((int)i)).instruction instanceof DestinationInstruction)) continue;
            return ((ScheduleEntry)schedule.entries.get((int)i)).instruction.getData().m_128461_("Text");
        }
        for (i = 0; i < schedule.entries.size(); ++i) {
            if (!(((ScheduleEntry)schedule.entries.get((int)i)).instruction instanceof DestinationInstruction)) continue;
            return ((ScheduleEntry)schedule.entries.get((int)i)).instruction.getData().m_128461_("Text");
        }
        return "Nowhere";
    }
}

