/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.vcinteraction;

import de.maxhenkel.vcinteraction.AudioUtils;
import de.maxhenkel.vcinteraction.VoicechatInteraction;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_3222;

public class Plugin
implements VoicechatPlugin {
    public static VoicechatApi voicechatApi;
    private static ConcurrentHashMap<UUID, Long> cooldowns;
    @Nullable
    public static VoicechatServerApi voicechatServerApi;
    @Nullable
    private OpusDecoder decoder;

    public String getPluginId() {
        return "vcinteraction";
    }

    public void initialize(VoicechatApi api) {
        voicechatApi = api;
        cooldowns = new ConcurrentHashMap();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicPacket);
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        voicechatServerApi = event.getVoicechat();
    }

    private void onMicPacket(MicrophonePacketEvent event) {
        VoicechatConnection senderConnection = event.getSenderConnection();
        if (senderConnection == null) {
            return;
        }
        if (((MicrophonePacket)event.getPacket()).getOpusEncodedData().length <= 0) {
            return;
        }
        if (!VoicechatInteraction.SERVER_CONFIG.groupInteraction.get().booleanValue() && senderConnection.isInGroup()) {
            return;
        }
        if (!VoicechatInteraction.SERVER_CONFIG.whisperInteraction.get().booleanValue() && ((MicrophonePacket)event.getPacket()).isWhispering()) {
            return;
        }
        Object object = senderConnection.getPlayer().getPlayer();
        if (!(object instanceof class_3222)) {
            VoicechatInteraction.LOGGER.warn("Received microphone packets from non-player");
            return;
        }
        class_3222 player = (class_3222)object;
        if (!VoicechatInteraction.SERVER_CONFIG.sneakInteraction.get().booleanValue() && player.method_18276()) {
            return;
        }
        if (this.decoder == null) {
            this.decoder = event.getVoicechat().createDecoder();
        }
        this.decoder.resetState();
        short[] decoded = this.decoder.decode(((MicrophonePacket)event.getPacket()).getOpusEncodedData());
        if (AudioUtils.calculateAudioLevel(decoded) < VoicechatInteraction.SERVER_CONFIG.minActivationThreshold.get().doubleValue()) {
            return;
        }
        player.method_51469().method_8503().execute(() -> {
            if (this.activate(player)) {
                player.method_32876(VoicechatInteraction.VOICE_GAME_EVENT);
            }
        });
    }

    private boolean activate(class_3222 player) {
        Long lastTimestamp = cooldowns.get(player.method_5667());
        long currentTime = player.method_51469().method_75260();
        if (lastTimestamp == null || currentTime - lastTimestamp > 20L) {
            cooldowns.put(player.method_5667(), currentTime);
            return true;
        }
        return false;
    }
}

