/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows;

import bl4ckscor3.mod.scarecrows.Configuration;
import bl4ckscor3.mod.scarecrows.block.ArmBlock;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import bl4ckscor3.mod.scarecrows.type.ScaryScarecrow;
import bl4ckscor3.mod.scarecrows.type.SpookyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SpoopyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperScaryScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperSpookyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperSpoopyScarecrow;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="scarecrows")
@EventBusSubscriber(modid="scarecrows")
public class Scarecrows {
    public static final String MODID = "scarecrows";
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"scarecrows");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"scarecrows");
    public static final DeferredRegister<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"scarecrows");
    public static final DeferredBlock<ArmBlock> ARM = BLOCKS.registerBlock("arm", ArmBlock::new, BlockBehaviour.Properties.of().strength(0.25f, 1.0f).sound(SoundType.WOOD).isRedstoneConductor((state, world, pos) -> false));
    public static final DeferredHolder<EntityType<?>, EntityType<Scarecrow>> SCARECROW_ENTITY_TYPE = ENTITY_TYPES.register("scarecrow", () -> EntityType.Builder.of(Scarecrow::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).setTrackingRange(256).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"scarecrow"))));
    public static final StreamCodec<ByteBuf, AABB> AABB_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.minX, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.minY, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.minZ, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.maxX, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.maxY, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.maxZ, AABB::new);
    public static final StreamCodec<ByteBuf, ScarecrowType> SCARECROW_TYPE_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ScarecrowType::getName, name -> {
        for (ScarecrowType type : TYPES) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("Non-existent scarecrow type: " + name);
    });
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<ScarecrowType>> SCARECROW_ENTITY_DATA_SERIALIZER = ENTITY_DATA_SERIALIZERS.register("scarecrow_type", () -> EntityDataSerializer.forValueType(SCARECROW_TYPE_STREAM_CODEC));
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<AABB>> AABB_ENTITY_DATA_SERIALIZER = ENTITY_DATA_SERIALIZERS.register("aabb", () -> EntityDataSerializer.forValueType(AABB_STREAM_CODEC));
    public static final List<ScarecrowType> TYPES = new ArrayList<ScarecrowType>();

    public Scarecrows(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG_SPEC);
        BLOCKS.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        ENTITY_DATA_SERIALIZERS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        TYPES.add(SpoopyScarecrow.TYPE);
        TYPES.add(SuperSpoopyScarecrow.TYPE);
        TYPES.add(SpookyScarecrow.TYPE);
        TYPES.add(SuperSpookyScarecrow.TYPE);
        TYPES.add(ScaryScarecrow.TYPE);
        TYPES.add(SuperScaryScarecrow.TYPE);
    }
}

