/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.type;

import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.block.ArmBlock;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class ScarecrowType {
    private String name;
    private int height;
    private int range;
    private boolean scareAnimals;

    public ScarecrowType(String name, int height, int range, boolean scareAnimals) {
        this.name = name;
        this.height = height;
        this.range = range;
        this.scareAnimals = scareAnimals;
    }

    public abstract boolean checkStructure(LevelAccessor var1, BlockPos var2, Direction var3);

    public abstract void destroy(LevelAccessor var1, BlockPos var2);

    public abstract ItemStack[] getDrops();

    public String getName() {
        return this.name;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getRange() {
        return this.range;
    }

    public final boolean shouldScareAnimals() {
        return this.scareAnimals;
    }

    public final boolean hasArms(LevelAccessor level, BlockPos pos, Direction pumpkinFacing) {
        BlockPos posNorth = pos.north();
        BlockPos posEast = pos.east();
        BlockPos posSouth = pos.south();
        BlockPos posWest = pos.west();
        BlockState stateNorth = level.getBlockState(posNorth);
        BlockState stateEast = level.getBlockState(posEast);
        BlockState stateSouth = level.getBlockState(posSouth);
        BlockState stateWest = level.getBlockState(posWest);
        if ((pumpkinFacing == Direction.EAST || pumpkinFacing == Direction.WEST) && stateNorth.is(Scarecrows.ARM) && stateNorth.getValue(ArmBlock.FACING) == Direction.NORTH && stateSouth.is(Scarecrows.ARM) && stateSouth.getValue(ArmBlock.FACING) == Direction.SOUTH && stateWest.isAir() && stateEast.isAir()) {
            return true;
        }
        return (pumpkinFacing == Direction.NORTH || pumpkinFacing == Direction.SOUTH) && stateEast.is(Scarecrows.ARM) && stateEast.getValue(ArmBlock.FACING) == Direction.EAST && stateWest.is(Scarecrows.ARM) && stateWest.getValue(ArmBlock.FACING) == Direction.WEST && stateNorth.isAir() && stateSouth.isAir();
    }

    public final void spawn(ScarecrowType type, LevelAccessor level, BlockPos pos, boolean isLit, Direction facing) {
        if (isLit) {
            ((Level)level).setBlockAndUpdate(pos.above(this.height - 1), (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)));
        }
        level.addFreshEntity((Entity)new Scarecrow(type, (Level)level, pos, isLit, facing));
    }

    public final void dropMaterials(Level level, BlockPos pos, boolean dropLight) {
        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)(dropLight ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN)));
        for (ItemStack stack : this.getDrops()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
    }
}

