/*
 * Decompiled with CFR 0.152.
 */
package orionlabs.ratsend.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import orionlabs.ratsend.command.ResetArmorCooldownCommand;
import orionlabs.ratsend.item.ModItems;

@Mod.EventBusSubscriber(modid="ratsend")
public class ModEvents {
    public static final String COOLDOWN_TAG = "ratsend.ender_escape.cooldown";
    public static final int COOLDOWN_TICKS = 6000;

    @SubscribeEvent
    public static void onEnchantmentLevelSet(EnchantmentLevelSetEvent event) {
        ItemStack itemStack = event.getItem();
        if ((itemStack.m_41720_() == ModItems.ENDERITE_HELMET.get() || itemStack.m_41720_() == ModItems.ENDERITE_CHESTPLATE.get() || itemStack.m_41720_() == ModItems.ENDERITE_LEGGINGS.get() || itemStack.m_41720_() == ModItems.ENDERITE_BOOTS.get()) && event.getPower() >= 30 && event.getEnchantLevel() > 0) {
            event.setEnchantLevel(event.getEnchantLevel() + 1);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && !event.getEntity().m_9236_().m_5776_() && ModEvents.hasFullEnderiteArmor(player = (Player)event.getEntity())) {
            long lastUsedTime = player.getPersistentData().m_128454_(COOLDOWN_TAG);
            long currentTime = player.m_9236_().m_46467_();
            if (currentTime - lastUsedTime >= 6000L) {
                event.setCanceled(true);
                player.m_21153_(1.0f);
                player.m_21219_();
                ModEvents.teleportPlayerRandomly(player);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (player.m_9236_() instanceof ServerLevel) {
                    ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 50, 0.5, 1.0, 0.5, 0.1);
                }
                player.getPersistentData().m_128356_(COOLDOWN_TAG, currentTime);
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ResetArmorCooldownCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static boolean hasFullEnderiteArmor(Player player) {
        ItemStack helmet = player.m_150109_().m_36052_(3);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack boots = player.m_150109_().m_36052_(0);
        return !helmet.m_41619_() && helmet.m_41720_() == ModItems.ENDERITE_HELMET.get() && !chestplate.m_41619_() && chestplate.m_41720_() == ModItems.ENDERITE_CHESTPLATE.get() && !leggings.m_41619_() && leggings.m_41720_() == ModItems.ENDERITE_LEGGINGS.get() && !boots.m_41619_() && boots.m_41720_() == ModItems.ENDERITE_BOOTS.get();
    }

    private static void teleportPlayerRandomly(Player player) {
        double teleportRange = 96.0;
        for (int i = 0; i < 32; ++i) {
            double z;
            double y;
            double x = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * teleportRange;
            if (!player.m_20984_(x, y = player.m_20186_() + (double)(player.m_217043_().m_188503_(32) - 16), z = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * teleportRange, true)) continue;
            return;
        }
    }
}

