/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.event.TrEntityEPProvider;
import com.github.dominickwd04.traddon.event.TrEntityTagProvider;
import com.github.dominickwd04.traddon.proxy.ClientProxy;
import com.github.dominickwd04.traddon.proxy.CommonProxy;
import com.github.dominickwd04.traddon.proxy.ServerProxy;
import com.github.dominickwd04.traddon.registry.TrRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="traddon")
public class Traddon {
    public static final String MOD_ID = "traddon";
    private static final Logger logger = LogManager.getLogger((String)"traddon");
    private static Traddon instance;
    private final CommonProxy proxy;

    public Traddon() {
        instance = this;
        this.proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TrConfig.SPEC, this.getConfigFileName("tr-config"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.proxy.preInit(modEventBus);
        TrRegistry.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::generateData);
        modEventBus.addListener(this.proxy::init);
        modEventBus.addListener(this.proxy::clientSetup);
        modEventBus.addListener(this.proxy::serverSetup);
    }

    private void generateData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.m_236039_(event.includeClient(), (DataProvider)new TrEntityEPProvider(event));
        gen.m_236039_(event.includeClient(), (DataProvider)new TrEntityTagProvider(event));
    }

    private String getConfigFileName(String name) {
        return String.format("%s/%s.toml", "tensura-reincarnated", name);
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        logger.info("Common Setup");
        if (this.isFirstLaunch()) {
            this.editTOMLFile();
            this.markAsEdited();
            logger.info("Common setup works and TOML file was edited.");
        } else {
            logger.info("Common setup works. TOML file already edited.");
        }
    }

    private boolean isFirstLaunch() {
        File markerFile = new File("defaultconfigs/tensura-reincarnated/traddon_first_launch_marker");
        return !markerFile.exists();
    }

    private void markAsEdited() {
        File markerFile = new File("defaultconfigs/tensura-reincarnated/traddon_first_launch_marker");
        try {
            if (markerFile.createNewFile()) {
                System.out.println("Marker file created: " + markerFile.getAbsolutePath());
            } else {
                System.out.println("Marker file already exists.");
            }
        }
        catch (IOException var3) {
            var3.printStackTrace();
            System.out.println("Error creating marker file: " + var3.getMessage());
        }
    }

    public void editTOMLFile() {
        File tomlFile = new File("defaultconfigs/tensura-reincarnated/common.toml");
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(tomlFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                contentBuilder.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException var18) {
            var18.printStackTrace();
            System.out.println("Error reading the TOML file: " + var18.getMessage());
            return;
        }
        String content = contentBuilder.toString();
        String[] newSkills = new String[]{"traddon:deviator", "traddon:devastator", "traddon:spatial_samurai", "traddon:disruptor"};
        String reincarnationSkillsKey = "reincarnationSkills = [";
        content = this.addItemsToTOMLList(content, reincarnationSkillsKey, newSkills);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tomlFile));){
            writer.write(content);
        }
        catch (IOException var16) {
            var16.printStackTrace();
            System.out.println("Error writing to the TOML file: " + var16.getMessage());
        }
        System.out.println("Items added to TOML lists successfully.");
    }

    private String addItemsToTOMLList(String content, String listKey, String[] newItems) {
        int index = content.indexOf(listKey);
        if (index == -1) {
            System.out.println("List identifier '" + listKey + "' not found.");
            return content;
        }
        int endIndex = content.indexOf("]", index) + 1;
        if (endIndex == 0) {
            System.out.println("Closing bracket not found for list: " + listKey);
            return content;
        }
        String listContent = content.substring(index, endIndex);
        String[] var7 = newItems;
        int var8 = newItems.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            String newItem = var7[var9];
            if (listContent.contains(newItem)) continue;
            listContent = listContent.replace("]", ", \"" + newItem + "\"]");
        }
        return content.replace(content.substring(index, endIndex), listContent);
    }
}

