/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.intrinsic;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class DragonSpiritHakiSkill
extends Skill {
    public DragonSpiritHakiSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/extra/demon_lord_haki.png");
    }

    public double learningCost() {
        return 500000.0;
    }

    public int modes() {
        return 5;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return reverse ? (instance.getMode() == 1 ? 6 : instance.getMode() - 1) : (instance.getMode() == 6 ? 1 : instance.getMode() + 1);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.haki.coat");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.haki.release");
            case 3 -> Component.m_237115_((String)"traddon.skill.mode.haki.fire");
            case 4 -> Component.m_237115_((String)"traddon.skill.mode.haki.water");
            case 5 -> Component.m_237115_((String)"traddon.skill.mode.haki.earth");
            case 6 -> Component.m_237115_((String)"traddon.skill.mode.haki.wind");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            if (!entity.m_21023_((MobEffect)TensuraMobEffects.HAKI_COAT.get())) {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HAKI_COAT.get(), 2400, 3, false, false, false));
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                entity.m_21195_((MobEffect)TensuraMobEffects.HAKI_COAT.get());
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        DragonSpiritHakiSkill.activateDemonLordHaki(instance, entity, heldTicks);
        return true;
    }

    public static void activateDemonLordHaki(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 2 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:demon_lord_haki"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            double scale = instance.getTag() == null ? 0.0 : instance.getTag().m_128459_("scale");
            double multiplier = scale == 0.0 ? 1.0 : Math.min(scale, 1.0);
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity) * multiplier;
            Iterator var10 = list.iterator();
            while (true) {
                if (!var10.hasNext()) {
                    return;
                }
                LivingEntity target = (LivingEntity)var10.next();
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                double targetEP = TensuraEPCapability.getEP((LivingEntity)target);
                double difference = ownerEP / targetEP;
                if (!(difference <= 2.0)) {
                    int fearLevel = (int)(difference * 0.5 - 1.0);
                    fearLevel = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().contains(SkillAPI.getSkillRegistry().getValue(new ResourceLocation("traddon:dragon_spirit_haki"))) && difference >= 1.0 ? (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get() : Math.min(fearLevel * 2, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FEAR.get()), (int)200, (int)fearLevel);
                    HakiSkill.hakiPush((LivingEntity)target, (LivingEntity)entity, (int)fearLevel);
                }
                float damage = (float)((double)((Integer)TrConfig.INSTANCE.skillsConfig.DragonSpiritHakiDamage.get()).intValue() <= 0.0 ? (double)Math.abs((Integer)TrConfig.INSTANCE.skillsConfig.DragonSpiritHakiDamage.get()) : difference * (double)((Integer)TrConfig.INSTANCE.skillsConfig.DragonSpiritHakiDamage.get()).intValue());
                switch (instance.getMode()) {
                    case 2: {
                        TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)TensuraDamageSources.fear((Entity)entity)).setIgnoreBarrier(1.0f).setIgnoreResistance((float)heldTicks);
                        target.m_6469_((DamageSource)source, damage);
                        break;
                    }
                    case 3: {
                        target.m_20254_(10);
                        TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)TensuraDamageSources.elementalAttack((String)"tensura.fire_attack", (Entity)entity, (double)5000.0, (ManasSkillInstance)instance, (boolean)false)).setIgnoreBarrier(1.0f);
                        target.m_6469_((DamageSource)source, damage);
                        break;
                    }
                    case 4: {
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.CHILL.get()), (int)200, (int)1);
                        TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)TensuraDamageSources.elementalAttack((String)"tensura.water_attack", (Entity)entity, (double)5000.0, (ManasSkillInstance)instance, (boolean)false)).setIgnoreBarrier(1.0f);
                        target.m_6469_((DamageSource)source, damage);
                        break;
                    }
                    case 5: {
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.BURDEN.get()), (int)200, (int)1);
                        TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)TensuraDamageSources.elementalAttack((String)"tensura.earth_attack", (Entity)entity, (double)5000.0, (ManasSkillInstance)instance, (boolean)false)).setIgnoreBarrier(1.0f);
                        target.m_6469_((DamageSource)source, damage);
                        break;
                    }
                    case 6: {
                        HakiSkill.hakiPush((LivingEntity)target, (LivingEntity)entity, (int)20);
                        TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)TensuraDamageSources.elementalAttack((String)"tensura.wind_attack", (Entity)entity, (double)5000.0, (ManasSkillInstance)instance, (boolean)false)).setIgnoreBarrier(1.0f);
                        target.m_6469_((DamageSource)source, damage);
                    }
                }
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() != 1) {
            HakiSkill.changeEPUsed((ManasSkillInstance)instance, (LivingEntity)entity, (double)delta);
        }
    }
}

