/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.DragonSkinSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.attribute.TensuraAttributeHelper;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class ExoskeletonSkill
extends Skill {
    protected static final UUID EXOSKELETON = UUID.fromString("928f0316-3fdd-11ee-be56-0242ac120002");

    public ExoskeletonSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/intrinsic/scale_armor.png");
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return !this.hasArmor(entity);
    }

    private boolean hasArmor(LivingEntity entity) {
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor == null) {
            return false;
        }
        boolean hasArmor = false;
        for (int i = 0; i <= 3; ++i) {
            if (armor.m_22111_((UUID)TensuraAttributeHelper.ARMOR_MODIFIER_UUID_PER_SLOT.get(i)) == null) continue;
            hasArmor = true;
            break;
        }
        return hasArmor;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance toughness;
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null && armor.m_22111_(EXOSKELETON) == null) {
            armor.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", (double)this.calculateArmor(entity), AttributeModifier.Operation.ADDITION));
        }
        if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null && toughness.m_22111_(EXOSKELETON) == null) {
            toughness.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", (double)this.calculateToughness(entity, instance), AttributeModifier.Operation.ADDITION));
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance toughness;
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null) {
            armor.m_22120_(EXOSKELETON);
        }
        if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null) {
            toughness.m_22120_(EXOSKELETON);
        }
    }

    protected int calculateArmor(LivingEntity entity) {
        int armor = 0;
        double EP = TensuraEPCapability.getEP((LivingEntity)entity);
        if (EP <= 20000.0) {
            armor = (int)(EP / 2000.0);
        } else if (EP <= 100000.0) {
            armor = 10 + (int)((EP - 20000.0) / 5000.0);
        } else {
            armor = 26 + (int)((EP - 120000.0) / 20000.0);
            armor = Math.min(armor, 50);
        }
        return armor;
    }

    protected float calculateToughness(LivingEntity entity, ManasSkillInstance instance) {
        return (float)this.calculateArmor(entity) / (instance.isMastered(entity) ? 5.0f : 10.0f);
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled()) {
            SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)IntrinsicSkills.DRAGON_SKIN.get()).ifPresent(skill -> {
                if (skill.isToggled()) {
                    skill.setToggled(false);
                    skill.onToggleOff(entity);
                    skill.markDirty();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_requirement.toggled_off", (Object[])new Object[]{((DragonSkinSkill)IntrinsicSkills.DRAGON_SKIN.get()).getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                }
            });
        }
        if (this.hasArmor(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_requirement.toggled_off", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            instance.setToggled(false);
            instance.onToggleOff(entity);
            instance.markDirty();
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 6 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        AttributeInstance toughness = entity.m_21051_(Attributes.f_22285_);
        double armorValue = this.calculateArmor(entity);
        if (armor.m_22111_(EXOSKELETON).m_22218_() != armorValue) {
            armor.m_22120_(EXOSKELETON);
            armor.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", armorValue, AttributeModifier.Operation.ADDITION));
            toughness.m_22120_(EXOSKELETON);
            toughness.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", (double)this.calculateToughness(entity, instance), AttributeModifier.Operation.ADDITION));
        }
    }
}

