/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.intrinsic;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.registry.item.TrItems;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.race.daemon.LesserDaemonRace;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MaterialCreationSkill
extends Skill {
    public MaterialCreationSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/intrinsic/body_armor.png");
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (TensuraPlayerCapability.getRace((LivingEntity)entity) instanceof LesserDaemonRace && (Integer)TrConfig.INSTANCE.skillsConfig.materialCreation.get() >= 0) {
            return newEP >= (double)((Integer)TrConfig.INSTANCE.skillsConfig.materialCreation.get()).intValue();
        }
        return false;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 5000.0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 10 == 0) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!entity.m_6844_(slot).m_204117_(TensuraTags.Items.BODY_ARMOR_ITEMS)) continue;
                this.addMasteryPoint(instance, entity);
            }
            tag.m_128405_("activatedTimes", 0);
        } else {
            tag.m_128405_("activatedTimes", time + 1);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        double EP = TensuraEPCapability.getEP((LivingEntity)entity);
        int tier = EP >= 400000.0 ? 3 : (EP >= 100000.0 ? 2 : 1);
        if (entity.m_6144_()) {
            if (entity.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && !SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                if (tier == 1) {
                    entity.m_8061_(EquipmentSlot.MAINHAND, ((Item)TrItems.MATERIAL_CREATE_1_SWORD.get()).m_7968_());
                } else if (tier == 2) {
                    entity.m_8061_(EquipmentSlot.MAINHAND, ((Item)TrItems.MATERIAL_CREATE_2_SWORD.get()).m_7968_());
                } else if (tier == 3) {
                    entity.m_8061_(EquipmentSlot.MAINHAND, ((Item)TrItems.MATERIAL_CREATE_3_SWORD.get()).m_7968_());
                }
            } else if (entity.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)TrItems.MATERIAL_CREATE_1_SWORD.get()) || entity.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)TrItems.MATERIAL_CREATE_2_SWORD.get()) || entity.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)TrItems.MATERIAL_CREATE_3_SWORD.get())) {
                entity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        } else if (!(entity.m_6844_(EquipmentSlot.HEAD).m_41619_() || entity.m_6844_(EquipmentSlot.CHEST).m_41619_() || entity.m_6844_(EquipmentSlot.LEGS).m_41619_() || entity.m_6844_(EquipmentSlot.FEET).m_41619_())) {
            if (entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)TrItems.MATERIAL_CREATE_1_HELMET.get()) || entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)TrItems.MATERIAL_CREATE_2_HELMET.get()) || entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)TrItems.MATERIAL_CREATE_3_HELMET.get())) {
                entity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
            }
            if (entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)TrItems.MATERIAL_CREATE_1_CHESTPLATE.get()) || entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)TrItems.MATERIAL_CREATE_2_CHESTPLATE.get()) || entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)TrItems.MATERIAL_CREATE_3_CHESTPLATE.get())) {
                entity.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            }
            if (entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)TrItems.MATERIAL_CREATE_1_LEGGINGS.get()) || entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)TrItems.MATERIAL_CREATE_2_LEGGINGS.get()) || entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)TrItems.MATERIAL_CREATE_3_LEGGINGS.get())) {
                entity.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
            }
            if (entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)TrItems.MATERIAL_CREATE_1_BOOTS.get()) || entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)TrItems.MATERIAL_CREATE_2_BOOTS.get()) || entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)TrItems.MATERIAL_CREATE_3_BOOTS.get())) {
                entity.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
            }
        } else if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            if (entity.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                if (tier == 1) {
                    entity.m_8061_(EquipmentSlot.HEAD, ((Item)TrItems.MATERIAL_CREATE_1_HELMET.get()).m_7968_());
                } else if (tier == 2) {
                    entity.m_8061_(EquipmentSlot.HEAD, ((Item)TrItems.MATERIAL_CREATE_2_HELMET.get()).m_7968_());
                } else if (tier == 3) {
                    entity.m_8061_(EquipmentSlot.HEAD, ((Item)TrItems.MATERIAL_CREATE_3_HELMET.get()).m_7968_());
                }
            }
            if (entity.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                if (tier == 1) {
                    entity.m_8061_(EquipmentSlot.CHEST, ((Item)TrItems.MATERIAL_CREATE_1_CHESTPLATE.get()).m_7968_());
                } else if (tier == 2) {
                    entity.m_8061_(EquipmentSlot.CHEST, ((Item)TrItems.MATERIAL_CREATE_2_CHESTPLATE.get()).m_7968_());
                } else if (tier == 3) {
                    entity.m_8061_(EquipmentSlot.CHEST, ((Item)TrItems.MATERIAL_CREATE_3_CHESTPLATE.get()).m_7968_());
                }
            }
            if (entity.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
                if (tier == 1) {
                    entity.m_8061_(EquipmentSlot.LEGS, ((Item)TrItems.MATERIAL_CREATE_1_LEGGINGS.get()).m_7968_());
                } else if (tier == 2) {
                    entity.m_8061_(EquipmentSlot.LEGS, ((Item)TrItems.MATERIAL_CREATE_2_LEGGINGS.get()).m_7968_());
                } else if (tier == 3) {
                    entity.m_8061_(EquipmentSlot.LEGS, ((Item)TrItems.MATERIAL_CREATE_3_LEGGINGS.get()).m_7968_());
                }
            }
            if (entity.m_6844_(EquipmentSlot.FEET).m_41619_()) {
                if (tier == 1) {
                    entity.m_8061_(EquipmentSlot.FEET, ((Item)TrItems.MATERIAL_CREATE_1_BOOTS.get()).m_7968_());
                } else if (tier == 2) {
                    entity.m_8061_(EquipmentSlot.FEET, ((Item)TrItems.MATERIAL_CREATE_2_BOOTS.get()).m_7968_());
                } else if (tier == 3) {
                    entity.m_8061_(EquipmentSlot.FEET, ((Item)TrItems.MATERIAL_CREATE_3_BOOTS.get()).m_7968_());
                }
            }
        }
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11679_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

