/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.intrinsic;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.registry.effects.TrMobEffects;
import com.github.dominickwd04.traddon.registry.race.TrRaces;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicUltils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.text.DecimalFormat;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class OuterDarknessSkill
extends Skill {
    protected final DecimalFormat roundDouble = new DecimalFormat("#.#");

    public OuterDarknessSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/extra/magic_darkness_transform.png");
    }

    public int modes() {
        return 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10000.0;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"traddon.skill.mode.outer_darkness.abyss_coat");
            case 2 -> Component.m_237115_((String)"traddon.skill.mode.outer_darkness.abyss_ray");
            default -> Component.m_237119_();
        };
    }

    public String modeLearningId(int mode) {
        return switch (mode) {
            case 2 -> "abyssRay";
            default -> "None";
        };
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled() && instance.isMastered(entity);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                double mpGain = maxMP * (TensuraPlayerCapability.getRace((LivingEntity)entity) == ((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ELDRITCH_SLIME) ? (Double)TrConfig.INSTANCE.skillsConfig.outerDarknessRegenEldritch.get() : (Double)TrConfig.INSTANCE.skillsConfig.outerDarknessRegen.get());
                cap.setMagicule(Math.min(cap.getMagicule() + mpGain, maxMP));
            });
            TensuraPlayerCapability.sync((Player)player);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && DamageSourceHelper.isDarkDamage((DamageSource)e.getSource())) {
            double m = (Double)TrConfig.INSTANCE.skillsConfig.outerDarknessBuff.get();
            double mm = (Double)TrConfig.INSTANCE.skillsConfig.outerDarknessBuffEldritch.get();
            float mult = (float)m;
            float eldritchMult = (float)mm;
            e.setAmount(e.getAmount() * (TensuraPlayerCapability.getRace((LivingEntity)living) == ((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ELDRITCH_SLIME) ? eldritchMult : mult));
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.getMode() == 2) {
            int learnPoint = tag.m_128451_("abyssRay");
            if (learnPoint < 100) {
                tag.m_128405_("abyssRay", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player = (Player)entity;
                    if (tag.m_128451_("abyssRay") >= 100) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(2)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    } else {
                        instance.setCoolDown(10);
                        SkillUtils.learningFailPenalty((LivingEntity)entity);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(2)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    }
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                instance.markDirty();
            }
            instance.getOrCreateTag().m_128405_("BeamID", 0);
            instance.markDirty();
        } else if (instance.getMode() == 1) {
            if (!entity.m_21023_((MobEffect)TrMobEffects.OUTER_DARKNESS.get())) {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.m_7292_(new MobEffectInstance((MobEffect)TrMobEffects.OUTER_DARKNESS.get(), 6000, 0, false, false, false));
            } else {
                entity.m_21195_((MobEffect)TrMobEffects.OUTER_DARKNESS.get());
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 0.5f);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.getMode() == 1 || tag.m_128451_("abyssRay") < 100) {
            return false;
        }
        if (heldTicks == 0 && this.alreadyCasting(entity)) {
            return false;
        }
        int castTime = this.castingTime(instance, entity);
        if (heldTicks % 100 == 0 && heldTicks > castTime) {
            this.addMasteryPoint(instance, entity);
        }
        if (heldTicks >= castTime) {
            double cost = this.magiculeCost(entity, instance);
            BeamProjectile.spawnLastingBeam((EntityType)((EntityType)TensuraEntityTypes.DARKNESS_CANNON.get()), (float)250.0f, (float)1.0f, (int)21, (float)20.0f, (float)0.0f, (Vec3)entity.m_146892_(), (LivingEntity)entity, (ManasSkillInstance)instance, (double)cost, (double)cost, (int)heldTicks);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 0.8f, 0.5f);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            this.addCastingParticle(instance, player, heldTicks);
        }
        return true;
    }

    public int castingTime(ManasSkillInstance instance, LivingEntity entity) {
        if (MagicUltils.hasChantAnnulment((LivingEntity)entity) && instance.isMastered(entity)) {
            return 1;
        }
        int castTime = instance.isMastered(entity) ? 40 : 80;
        return Math.max((int)((float)castTime * MagicUltils.castingSpeedMultipiler((LivingEntity)entity)), 1);
    }

    protected boolean alreadyCasting(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return false;
        }
        AttributeModifier modifier = attributeInstance.m_22111_(UUID.fromString("d1d356ef-eceb-41db-b85b-3174f8f149eb"));
        if (modifier == null) {
            return false;
        }
        return !modifier.m_22214_().equals(Util.m_137492_((String)"skill", (ResourceLocation)this.getRegistryName()));
    }

    protected void addCastingParticle(ManasSkillInstance instance, Player player, int heldTicks) {
        int cast = this.castingTime(instance, (LivingEntity)player);
        double sec = heldTicks >= cast ? (double)cast / 20.0 : (double)heldTicks / 20.0;
        player.m_5661_((Component)Component.m_237110_((String)"tensura.magic.cast_time.max", (Object[])new Object[]{this.roundDouble.format(sec), (double)cast / 20.0}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        if (MagicUltils.hasChantAnnulment((LivingEntity)player)) {
            if (heldTicks % 10 == 0) {
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123809_, (double)2.0);
            }
        } else {
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123809_, (double)2.0);
        }
    }
}

