/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.ultimate;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.entity.SummonedUndeadEntity;
import com.github.dominickwd04.traddon.registry.effects.TrMobEffects;
import com.github.dominickwd04.traddon.registry.entities.TrEntities;
import com.github.dominickwd04.traddon.registry.skill.TrSkills;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;

public class LichSkill
extends Skill {
    public static final UUID NECROMANCER = UUID.fromString("1465ec3c-4e31-11ee-be56-0242ac120002");
    protected static final UUID ACCELERATION = UUID.fromString("9cc54e77-84f6-4323-8439-423a193cec1e");
    public static final ImmutableList<MobEffect> NECRO = ImmutableList.of((Object)MobEffects.f_19614_, (Object)MobEffects.f_19615_, (Object)((MobEffect)TensuraMobEffects.FEAR.get()));

    public LichSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/unique/reaper.png");
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!((Boolean)TrConfig.INSTANCE.skillsConfig.UltimateEnabled.get()).booleanValue()) {
            return false;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        return (TensuraPlayerCapability.isTrueDemonLord((Player)entity) || TensuraPlayerCapability.isTrueHero((LivingEntity)entity)) && storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(TrSkills.NECROMANCER)).map(instance -> instance.isMastered((LivingEntity)entity)).orElse(false) != false;
    }

    public double getObtainingEpCost() {
        return 500000.0;
    }

    public int getMaxMastery() {
        return 2000;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 50000.0;
            case 2 -> 125000.0;
            default -> 1000.0;
        };
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return SkillAPI.getSkillsFrom((Entity)living).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(TrSkills.NECROMANCER)).map(skill -> !skill.isToggled()).orElse(true);
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled() && entity instanceof Player;
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getCoolDown() <= 50;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_20193_().m_45976_(SummonedUndeadEntity.class, entity.m_20191_().m_82400_(50.0)).size() >= (Integer)TrConfig.INSTANCE.skillsConfig.ReanimationSummonedUndeadMax.get() && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"traddon.skill.necromancer.too_many_undead", (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
            return;
        }
        if (this.getSouls(entity) >= (Integer)TrConfig.INSTANCE.skillsConfig.NecromancerSummonCost.get() * (instance.getMode() == 1 ? 1 : 3)) {
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                this.summonUndead(instance, entity, instance.getMode() == 1 ? 1 : 3);
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"traddon.skill.necromancer.no_souls", (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
        }
        TensuraPlayerCapability.sync((Player)((Player)entity));
    }

    public int modes() {
        return 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return reverse ? (instance.getMode() == 1 ? 2 : 1) : (instance.getMode() == 2 ? 1 : 2);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"traddon.skill.mode.necromancer.summon");
            case 2 -> Component.m_237115_((String)"traddon.skill.mode.necromancer.summon_3");
            default -> Component.m_237119_();
        };
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (instance.isToggled()) {
            e.getEntity().m_147207_(new MobEffectInstance((MobEffect)TrMobEffects.NECROSIS.get(), instance.isMastered(attacker) ? 2400 : 1200, instance.isMastered(attacker) ? 1 : 0, false, false), (Entity)attacker);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent e) {
        if (instance.isToggled() && e.getSource().m_7639_() == entity && DamageSourceHelper.isPhysicalAttack((DamageSource)e.getSource())) {
            DamageSourceHelper.directSpiritualHurt((LivingEntity)e.getEntity(), (Entity)entity, (float)e.getAmount(), (float)0.0f);
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        boolean maxShp;
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
        boolean bl = maxShp = TensuraEPCapability.getSpiritualHealth((LivingEntity)entity) == entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        if (entity instanceof Player) {
            AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
            AttributeModifier damageModifier = new AttributeModifier(NECROMANCER, "NecromancerAttack", LichSkill.getAttack(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (damage != null && !damage.m_22109_(damageModifier)) {
                damage.m_22125_(damageModifier);
            }
            AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
            AttributeModifier armorModifier = new AttributeModifier(NECROMANCER, "NecromancerArmor", LichSkill.getArmor(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (armor != null && !armor.m_22109_(armorModifier)) {
                armor.m_22125_(armorModifier);
            }
            AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
            AttributeModifier speedModifier = new AttributeModifier(NECROMANCER, "NecromancerSpeed", LichSkill.getSpeed(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (speed != null && !speed.m_22109_(speedModifier)) {
                speed.m_22125_(speedModifier);
            }
            AttributeInstance shp = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            AttributeModifier shpModifier = new AttributeModifier(NECROMANCER, "NecromancerShp", LichSkill.getShp(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (shp != null && !shp.m_22109_(shpModifier)) {
                shp.m_22125_(shpModifier);
            }
            if (maxShp) {
                TensuraEPCapability.setSpiritualHealth((LivingEntity)entity, (double)entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
            }
        }
    }

    public int getSouls(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return TensuraPlayerCapability.getFrom((Player)((Player)entity)).map(cap -> cap.getSoulPoints() / 1000).orElse(0);
        }
        return 0;
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        int level;
        AttributeInstance shp;
        AttributeInstance armor;
        AttributeInstance speed;
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
        AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
        if (damage != null && damage.m_22111_(NECROMANCER) != null) {
            damage.m_22127_(NECROMANCER);
        }
        if ((speed = entity.m_21051_(Attributes.f_22279_)) != null && speed.m_22111_(NECROMANCER) != null) {
            speed.m_22127_(NECROMANCER);
        }
        if ((armor = entity.m_21051_(Attributes.f_22284_)) != null && armor.m_22111_(NECROMANCER) != null) {
            armor.m_22127_(NECROMANCER);
        }
        if ((shp = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())) != null && shp.m_22111_(NECROMANCER) != null) {
            shp.m_22127_(NECROMANCER);
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get()) && (level = Objects.requireNonNull(entity.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())).m_19564_()) == 1) {
            entity.m_21195_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
        }
        entity.m_21195_((MobEffect)TensuraMobEffects.HEAT_SENSE.get());
        entity.m_21195_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get());
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled() && entity instanceof Player) {
            AttributeInstance shp = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            if (shp.m_22111_(NECROMANCER) != null && shp.m_22111_(NECROMANCER).m_22218_() != LichSkill.getShp(this.getSouls(entity))) {
                instance.onToggleOff(entity);
                instance.onToggleOn(entity);
            }
            for (LivingEntity livingEntity : entity.m_20193_().m_45976_(LivingEntity.class, entity.m_20191_().m_82400_(15.0))) {
                SummonedUndeadEntity undead;
                if (!(livingEntity instanceof SummonedUndeadEntity) || !(undead = (SummonedUndeadEntity)livingEntity).m_21805_().equals(entity.m_20148_()) || !(livingEntity.m_21223_() < livingEntity.m_21233_())) continue;
                livingEntity.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.SELF_REGENERATION.get(), 600, instance.isMastered(entity) ? 3 : 2, false, false), (Entity)entity);
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    public void summonUndead(ManasSkillInstance instance, LivingEntity entity, int amount) {
        Level level = entity.m_9236_();
        EntityType skeletonType = (EntityType)TrEntities.SUMMONED_UNDEAD.get();
        for (int i = 0; i < amount; ++i) {
            TensuraPlayerCapability.getFrom((Player)((Player)entity)).ifPresent(cap -> cap.setSoulPoints(cap.getSoulPoints() - this.getSoulCost()));
            SummonedUndeadEntity skeleton = new SummonedUndeadEntity((EntityType<? extends HumanoidNPCEntity>)skeletonType, level);
            skeleton.m_7678_(entity.m_20185_() + (Math.random() - 0.5) * 10.0, entity.m_20186_(), entity.m_20189_() + (Math.random() - 0.5) * 10.0, entity.m_6080_(), 0.0f);
            level.m_7967_((Entity)skeleton);
            skeleton.m_6710_(entity);
            skeleton.m_21816_(entity.m_20148_());
            TensuraEPCapability.getFrom((LivingEntity)skeleton).ifPresent(cap -> cap.setEP((LivingEntity)skeleton, 15000.0));
            TensuraEPCapability.getFrom((LivingEntity)skeleton).ifPresent(cap -> cap.setCurrentEP(entity, 15000.0));
            AttributeInstance damage = skeleton.m_21051_(Attributes.f_22281_);
            AttributeModifier damageModifier = new AttributeModifier(NECROMANCER, "NecromancerAttack", 15.0, AttributeModifier.Operation.ADDITION);
            if (damage != null && !damage.m_22109_(damageModifier)) {
                damage.m_22125_(damageModifier);
            }
            AttributeInstance armor = skeleton.m_21051_(Attributes.f_22284_);
            AttributeModifier armorModifier = new AttributeModifier(NECROMANCER, "NecromancerArmor", 16.0, AttributeModifier.Operation.ADDITION);
            if (armor != null && !armor.m_22109_(armorModifier)) {
                armor.m_22125_(armorModifier);
            }
            AttributeInstance shealth = skeleton.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            AttributeModifier shealthModifier = new AttributeModifier(NECROMANCER, "NecromancerHealth", 800.0, AttributeModifier.Operation.ADDITION);
            if (shealth != null && !shealth.m_22109_(shealthModifier)) {
                shealth.m_22125_(shealthModifier);
            }
            AttributeInstance health = skeleton.m_21051_(Attributes.f_22276_);
            AttributeModifier healthModifier = new AttributeModifier(NECROMANCER, "NecromancerHealth", 80.0, AttributeModifier.Operation.ADDITION);
            if (health != null && !health.m_22109_(healthModifier)) {
                health.m_22125_(healthModifier);
            }
            skeleton.m_21153_(120.0f);
            SkillAPI.getSkillsFrom((Entity)skeleton).learnSkill((ManasSkill)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get());
            SkillAPI.getSkillsFrom((Entity)skeleton).getSkill((ManasSkill)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get()).ifPresent(skill -> skill.setToggled(true));
            skeleton.m_6710_(null);
            this.addMasteryPoint(instance, entity);
        }
        if (!instance.isMastered(entity)) {
            instance.setCoolDown(instance.getCoolDown() + 10 * (instance.getMode() == 1 ? 1 : 2));
        } else {
            instance.setCoolDown(instance.getCoolDown() + 5 * (instance.getMode() == 1 ? 1 : 2));
        }
    }

    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        if (instance.isToggled() && e.getEntity() instanceof SummonedUndeadEntity) {
            TensuraPlayerCapability.getFrom((Player)((Player)owner)).ifPresent(cap -> cap.setSoulPoints(cap.getSoulPoints() + (int)((double)this.getSoulCost() * (Double)TrConfig.INSTANCE.skillsConfig.ReanimationSummonedDeathSoulReturn.get())));
            TensuraPlayerCapability.sync((Player)((Player)owner));
            instance.setCoolDown(instance.getCoolDown() - 10);
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        DamageSource source;
        if (!event.isCanceled() && (source = event.getSource()) != DamageSource.f_19317_) {
            LivingEntity livingEntity;
            TensuraDamageSource damageSource;
            if (source instanceof TensuraDamageSource && (damageSource = (TensuraDamageSource)source).getIgnoreBarrier() >= 3.0f) {
                return;
            }
            if (instance.isToggled() && (livingEntity = event.getEntity()) instanceof Player) {
                Player player = (Player)livingEntity;
                if (this.getSouls((LivingEntity)player) >= 10000 && instance.getCoolDown() <= 80) {
                    player.m_21153_(Math.max(player.m_21223_(), player.m_21233_()));
                    player.f_19802_ = Math.max(60, player.f_19802_);
                    TensuraEffectsCapability.resetEverything((LivingEntity)player, (boolean)false, (boolean)false);
                    TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setMagicule(Math.min(cap.getBaseMagicule(), cap.getMagicule() + 1000000.0)));
                    TensuraEPCapability.setSpiritualHealth((LivingEntity)player, (double)Math.min(TensuraEPCapability.getSpiritualHealth((LivingEntity)player) + 10000.0, player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())));
                    TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setSoulPoints(cap.getSoulPoints() - 10000000));
                    TensuraPlayerCapability.sync((Player)player);
                    player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, (double)1.0);
                    instance.setCoolDown(instance.getCoolDown() + 60);
                    event.setCanceled(true);
                } else {
                    LivingEntity sub = null;
                    for (LivingEntity livingEntity2 : player.m_20193_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(20.0))) {
                        SummonedUndeadEntity undead;
                        if (!(livingEntity2 instanceof SummonedUndeadEntity) || !(undead = (SummonedUndeadEntity)livingEntity2).m_21805_().equals(player.m_20148_())) continue;
                        sub = livingEntity2;
                    }
                    if (sub != null && instance.getCoolDown() <= 160) {
                        sub.m_142687_(Entity.RemovalReason.KILLED);
                        player.m_21153_(Math.min(2000.0f, player.m_21233_()));
                        player.f_19802_ = Math.max(60, player.f_19802_);
                        TensuraEffectsCapability.resetEverything((LivingEntity)player, (boolean)false, (boolean)false);
                        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setMagicule(Math.min(cap.getBaseMagicule(), cap.getMagicule() + 500000.0)));
                        TensuraEPCapability.setSpiritualHealth((LivingEntity)player, (double)Math.min(TensuraEPCapability.getSpiritualHealth((LivingEntity)player) + 4000.0, player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())));
                        TensuraPlayerCapability.sync((Player)player);
                        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, (double)1.0);
                        instance.setCoolDown(instance.getCoolDown() + 30);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int summonAmount = tag.m_128451_("summonAmount");
        if (summonAmount < 5) {
            tag.m_128405_("summonAmount", summonAmount + 1);
        } else {
            tag.m_128405_("summonAmount", 1);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"traddon.skill.summon_amount", (Object[])new Object[]{summonAmount + 1, new Object[0]}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
        }
        instance.markDirty();
    }

    public int getSoulCost() {
        return 1000 * (Integer)TrConfig.INSTANCE.skillsConfig.ReanimationSummonCost.get();
    }

    public static double getArmor(double souls) {
        return souls >= 10000.0 ? 50.0 : souls / 200.0;
    }

    public static double getAttack(double souls) {
        return souls >= 10000.0 ? 40.0 : souls / 250.0;
    }

    public static double getSpeed(double souls) {
        return (souls >= 5000.0 ? 10.0 : souls / 500.0) / 20.0;
    }

    public static double getShp(double souls) {
        return souls >= 10000.0 ? 5000.0 : souls / 2.0;
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        return NECRO;
    }
}

