/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.unique;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class DevastatorSkill
extends Skill {
    public static final UUID DEVASTATOR = UUID.fromString("9465ec3c-4e31-11ee-be56-0242ac120002");

    public DevastatorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return entity instanceof Player;
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/unique/berserker.png");
    }

    public double getObtainingEpCost() {
        return 20000.0;
    }

    public double learningCost() {
        return 1000.0;
    }

    public double magiculeCost(ManasSkillInstance instance, LivingEntity entity) {
        return 2000.0;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        double EP = TensuraEPCapability.getEP((LivingEntity)entity);
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(10);
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)TensuraParticles.SOLAR_FLASH.get()), (double)2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), (double)3.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), (double)2.0);
        TensuraParticleHelper.spawnServerParticles((Level)entity.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.PURPLE_LIGHTNING_SPARK.get()), (double)entity.m_20185_(), (double)(entity.m_20186_() + (double)(entity.m_20206_() / 2.0f)), (double)entity.m_20189_(), (int)100, (double)0.08, (double)0.08, (double)0.08, (double)0.2, (boolean)true);
        AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
        AttributeModifier damageModifier = new AttributeModifier(DEVASTATOR, "DevastatorAttack", instance.isMastered(entity) ? DevastatorSkill.getAttack(EP) * 2.0 : DevastatorSkill.getAttack(EP), AttributeModifier.Operation.ADDITION);
        if (damage != null && !damage.m_22109_(damageModifier)) {
            damage.m_22125_(damageModifier);
        }
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        AttributeModifier armorModifier = new AttributeModifier(DEVASTATOR, "DevastatorArmor", DevastatorSkill.getArmor(EP), AttributeModifier.Operation.ADDITION);
        if (armor != null && !armor.m_22109_(armorModifier)) {
            armor.m_22125_(armorModifier);
        }
        AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
        AttributeModifier speedModifier = new AttributeModifier(DEVASTATOR, "DevastatorSpeed", DevastatorSkill.getSpeed(EP) / 100.0, AttributeModifier.Operation.ADDITION);
        if (speed != null && !speed.m_22109_(speedModifier)) {
            speed.m_22125_(speedModifier);
        }
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent e) {
        if (this.isInSlot(entity) && e.getSource().m_7640_() == entity && DamageSourceHelper.isPhysicalAttack((DamageSource)e.getSource())) {
            LivingEntity target = e.getEntity();
            int durabilityBreak = (int)Math.max(2.0f, e.getAmount() / 2.0f);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && !target.m_6844_(slot).canPerformAction(ToolActions.SHIELD_BLOCK)) continue;
                ItemStack slotStack = target.m_6844_(slot);
                slotStack.m_41622_(durabilityBreak, target, living -> living.m_21166_(slot));
            }
            e.setAmount(e.getAmount() * (instance.isMastered(entity) ? 2.0f : 1.5f));
            DamageSourceHelper.directSpiritualHurt((LivingEntity)e.getEntity(), (Entity)entity, (DamageSource)e.getSource(), (float)(e.getAmount() * (instance.isMastered(entity) ? 3.0f : 2.0f)));
            this.addMasteryPoint(instance, entity);
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance armor;
        AttributeInstance speed;
        AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
        if (damage != null && damage.m_22111_(DEVASTATOR) != null) {
            damage.m_22127_(DEVASTATOR);
        }
        if ((speed = entity.m_21051_(Attributes.f_22279_)) != null && speed.m_22111_(DEVASTATOR) != null) {
            speed.m_22127_(DEVASTATOR);
        }
        if ((armor = entity.m_21051_(Attributes.f_22284_)) != null && armor.m_22111_(DEVASTATOR) != null) {
            armor.m_22127_(DEVASTATOR);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1 && !SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Level level = entity.m_9236_();
            Vec3 targetPos = entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(14.0));
            Vec3 source = entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(2.0));
            Vec3 offSetToTarget = targetPos.m_82546_(source);
            Vec3 normalizes = offSetToTarget.m_82541_();
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
            boolean success = false;
            for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
                Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
                ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SONIC_SOUND.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(4.0);
                List livingEntityList = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity) && !entityData.m_7307_((Entity)entity));
                if (!livingEntityList.isEmpty()) {
                    success = true;
                    for (LivingEntity target : livingEntityList) {
                        double damage;
                        double targetEP = TensuraEPCapability.getEP((LivingEntity)target);
                        double cost = (Double)TrConfig.INSTANCE.skillsConfig.devastatorCost.get() <= 0.0 ? Math.abs((Double)TrConfig.INSTANCE.skillsConfig.devastatorCost.get()) : targetEP * (Double)TrConfig.INSTANCE.skillsConfig.devastatorCost.get();
                        if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)cost)) continue;
                        if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
                            if (targetEP < ownerEP * (Double)TrConfig.INSTANCE.skillsConfig.devastatorKillPercentNull.get()) {
                                target.m_6469_(TensuraDamageSources.fear((Entity)entity), Float.MAX_VALUE);
                                target.f_20919_ = 19;
                                target.m_217045_();
                                level.m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_144094_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, (double)2.0, (int)20);
                                continue;
                            }
                            if (!(targetEP < ownerEP * 0.5)) continue;
                            damage = 10.0;
                            target.m_6469_(TensuraDamageSources.fear((Entity)entity), (float)damage);
                            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FEAR.get(), 200, 4, false, false, true));
                            SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FEAR.get()), (int)200, (int)20);
                            level.m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_144094_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, (double)2.0, (int)20);
                            continue;
                        }
                        if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()))) {
                            if (targetEP < ownerEP * (Double)TrConfig.INSTANCE.skillsConfig.devastatorKillPercentResist.get()) {
                                target.m_6469_(TensuraDamageSources.fear((Entity)entity), Float.MAX_VALUE);
                                target.f_20919_ = 19;
                                target.m_217045_();
                                level.m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_144094_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, (double)2.0, (int)20);
                                continue;
                            }
                            if (!(targetEP < ownerEP * 0.75)) continue;
                            damage = 10.0;
                            target.m_6469_(TensuraDamageSources.fear((Entity)entity), (float)damage);
                            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FEAR.get(), 200, 4, false, false, true));
                            SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FEAR.get()), (int)200, (int)20);
                            level.m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_144094_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, (double)2.0, (int)20);
                            continue;
                        }
                        if (!(targetEP < ownerEP * (Double)TrConfig.INSTANCE.skillsConfig.devastatorKillPercent.get())) continue;
                        target.m_6469_(TensuraDamageSources.fear((Entity)entity), Float.MAX_VALUE);
                        target.f_20919_ = 19;
                        target.m_217045_();
                        level.m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_144094_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, (double)2.0, (int)20);
                    }
                }
                if (!success) continue;
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 1 : 2);
            }
        }
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public int modes() {
        return 2;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"traddon.skill.mode.devastator.demonic_presence_kill");
            case 2 -> Component.m_237115_((String)"traddon.skill.mode.devastator.demonic_presence");
            default -> Component.m_237119_();
        };
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 2) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 200 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        DevastatorSkill.activateDemonLordHaki(entity, heldTicks);
        return true;
    }

    public static void activateDemonLordHaki(LivingEntity entity, int heldTicks) {
        List list;
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 2 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:demon_lord_haki"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity);
            Iterator var5 = list.iterator();
            while (true) {
                double targetEP;
                double difference;
                if (!var5.hasNext()) {
                    return;
                }
                LivingEntity target = (LivingEntity)var5.next();
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = ownerEP / (targetEP = TensuraEPCapability.getEP((LivingEntity)target))) <= 2.0) continue;
                int fearLevel = (int)(difference * 0.5 - 1.0);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FEAR.get()), (int)200, (int)fearLevel);
                HakiSkill.hakiPush((LivingEntity)target, (LivingEntity)entity, (int)fearLevel);
            }
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return false;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
    }

    public static double getArmor(double EP) {
        return EP >= 500000.0 ? 40.0 : EP / 12500.0;
    }

    public static double getAttack(double EP) {
        if (EP <= 20000.0) {
            return 10.0;
        }
        if (EP >= 2000000.0) {
            return 110.0;
        }
        double attackIncrease = EP / 20000.0;
        return 10.0 + attackIncrease;
    }

    public static double getSpeed(double EP) {
        return EP >= 500000.0 ? 20.0 : EP / 25000.0;
    }
}

