/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class DisruptorSkill
extends Skill {
    public DisruptorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/unique/suppressor.png");
    }

    public double getObtainingEpCost() {
        return 25000.0;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 1500.0;
            case 2 -> 500.0;
            case 3 -> 5000.0;
            default -> 0.0;
        };
    }

    public int modes() {
        return 4;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return reverse ? (instance.getMode() == 1 ? 4 : instance.getMode() - 1) : (instance.getMode() == 4 ? 1 : instance.getMode() + 1);
    }

    public String modeLearningId(int mode) {
        return mode == 3 ? "systemShutdown" : "None";
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMode() == 4;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"traddon.skill.mode.disruptor.mind_scramble");
            case 2 -> Component.m_237115_((String)"traddon.skill.mode.disruptor.motion_cancel");
            case 3 -> Component.m_237115_((String)"traddon.skill.mode.disruptor.system_shutdown");
            case 4 -> Component.m_237115_((String)"traddon.skill.mode.disruptor.gravity_manipulation");
            default -> Component.m_237119_();
        };
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled()) {
            if (DamageSourceHelper.isSpatialDamage((DamageSource)e.getSource())) {
                if (instance.isMastered(living) ? SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.SPATIAL_DOMINATION.get())) : SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get()))) {
                    return;
                }
                if (instance.isMastered(living) && SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get()))) {
                    e.setAmount(e.getAmount() * 2.0f);
                } else if (instance.isMastered(living) && !SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.SPATIAL_DOMINATION.get()))) {
                    e.setAmount(e.getAmount() * 4.0f);
                } else if (!SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get()))) {
                    e.setAmount(e.getAmount() * 2.0f);
                }
            }
            if (DamageSourceHelper.isGravityDamage((DamageSource)e.getSource())) {
                if (instance.isMastered(living) ? SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get())) : SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get()))) {
                    return;
                }
                if (instance.isMastered(living) && SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get()))) {
                    e.setAmount(e.getAmount() * 2.0f);
                } else if (instance.isMastered(living) && !SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get()))) {
                    e.setAmount(e.getAmount() * 4.0f);
                } else if (!SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get()))) {
                    e.setAmount(e.getAmount() * 2.0f);
                }
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                this.mindScramble(instance, entity);
                break;
            }
            case 2: {
                this.motionCancel(instance, entity);
                break;
            }
            case 3: {
                int learnPoint = tag.m_128451_("systemShutdown");
                if (learnPoint < 100) {
                    tag.m_128405_("systemShutdown", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("systemShutdown") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty((LivingEntity)entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    break;
                }
                this.systemShutdown(instance, entity);
                break;
            }
            case 4: {
                this.gravityManip(instance, entity);
            }
        }
    }

    private void mindScramble(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Level level = entity.m_9236_();
            Vec3 targetPos = entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(14.0));
            Vec3 source = entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(2.0));
            Vec3 offSetToTarget = targetPos.m_82546_(source);
            Vec3 normalizes = offSetToTarget.m_82541_();
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
            boolean success = false;
            for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
                Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
                ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SONIC_SOUND.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(4.0);
                List livingEntityList = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity) && !entityData.m_7307_((Entity)entity));
                if (livingEntityList.isEmpty()) continue;
                success = true;
                for (LivingEntity target : livingEntityList) {
                    int spiritTime;
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (DamageSource)TensuraDamageSources.mindRequiem((Entity)entity), (float)(instance.isMastered(entity) ? 200.0f : 50.0f));
                    int spiritAmp = this.SpiritAmp(entity, instance, target, 1);
                    int n = spiritTime = spiritAmp == 0 ? 30 : 180;
                    if (spiritAmp < 0) continue;
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, spiritTime, 0, false, false));
                }
            }
            if (success) {
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 2 : 5);
            }
        }
    }

    private void motionCancel(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return;
        }
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
        for (LivingEntity target : list) {
            int gravityTime;
            int spatialAmp = this.spatialAmp(entity, instance, target, 1);
            int spatialTime = spatialAmp == 0 ? 300 : 600;
            int gravityAmp = this.gravityAmp(entity, instance, target, 1);
            int n = gravityTime = gravityAmp == 0 ? 300 : 600;
            if (spatialAmp >= 0) {
                target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get(), spatialTime, spatialAmp, false, false));
            }
            if (gravityAmp < 0) continue;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, gravityTime, gravityAmp, false, false));
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), gravityTime, gravityAmp, false, false));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, gravityTime, gravityAmp, false, false));
        }
        entity.f_19853_.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
        instance.setCoolDown(10);
        this.addMasteryPoint(instance, entity);
    }

    private void systemShutdown(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)20.0, (boolean)false);
        int spatialAmp = this.spatialAmp(entity, instance, target, 2);
        int spatialTime = spatialAmp == 0 ? 300 : 600;
        int gravityAmp = this.gravityAmp(entity, instance, target, 2);
        int gravityTime = gravityAmp == 0 ? 300 : 600;
        int spiritAmp = this.SpiritAmp(entity, instance, target, 1);
        int spiritTime = spiritAmp == 0 ? 30 : 180;
        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FRAGILITY.get(), 600, 0, false, false));
        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 600, 0, false, false));
        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ANTI_SKILL.get(), 120, 0, false, false));
        if (spatialAmp >= 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, spatialTime, spatialAmp, false, false));
        }
        if (gravityAmp >= 0) {
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), gravityTime, gravityAmp, false, false));
        }
        if (spiritAmp >= 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, spiritTime, 0, false, false));
        }
        DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (DamageSource)TensuraDamageSources.mindRequiem((Entity)entity), (float)(instance.isMastered(entity) ? 500.0f : 200.0f));
        instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
        entity.f_19853_.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
        this.addMasteryPoint(instance, entity);
    }

    public void gravityManip(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player = (Player)entity;
            if (!(player.m_7500_() || player.m_5833_() || SkillHelper.outOfMagicule((LivingEntity)player, (ManasSkillInstance)instance))) {
                if (player.m_150110_().f_35936_) {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                } else {
                    this.addMasteryPoint(instance, entity);
                    player.m_150110_().f_35936_ = true;
                    player.m_150110_().f_35935_ = true;
                }
                player.m_6885_();
                player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public int spatialAmp(LivingEntity entity, ManasSkillInstance instance, LivingEntity target, int amp) {
        amp = SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "spatial_domination"))).isPresent() || instance.isMastered(entity) ? amp + 2 : amp;
        amp = SkillAPI.getSkillsFrom((Entity)target).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "spatial_domination"))).isPresent() ? amp - 1 : amp;
        int n = amp = SkillAPI.getSkillsFrom((Entity)target).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "spatial_manipulation"))).isPresent() ? amp - 1 : amp;
        amp = TensuraEPCapability.getEP((LivingEntity)entity) < TensuraEPCapability.getEP((LivingEntity)target) ? ((double)amp - TensuraEPCapability.getEP((LivingEntity)entity) / TensuraEPCapability.getEP((LivingEntity)target) <= 0.5 ? 2 : 1) : amp;
        return amp;
    }

    public int gravityAmp(LivingEntity entity, ManasSkillInstance instance, LivingEntity target, int amp) {
        amp = SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "gravity_domination"))).isPresent() || instance.isMastered(entity) ? amp + 2 : amp;
        amp = SkillAPI.getSkillsFrom((Entity)target).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "gravity_domination"))).isPresent() ? amp - 1 : amp;
        int n = amp = SkillAPI.getSkillsFrom((Entity)target).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "gravity_manipulation"))).isPresent() ? amp - 1 : amp;
        amp = TensuraEPCapability.getEP((LivingEntity)entity) < TensuraEPCapability.getEP((LivingEntity)target) ? ((double)amp - TensuraEPCapability.getEP((LivingEntity)entity) / TensuraEPCapability.getEP((LivingEntity)target) <= 0.5 ? 2 : 1) : amp;
        return this.spatialAmp(entity, instance, target, amp) >= 1 ? amp + 1 : amp;
    }

    public int SpiritAmp(LivingEntity entity, ManasSkillInstance instance, LivingEntity target, int amp) {
        amp = SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "spiritual_attack_resistance"))).isPresent() ? amp - 1 : amp;
        amp = SkillAPI.getSkillsFrom((Entity)target).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation("tensura", "spiritual_attack_nullification"))).isPresent() ? amp - 1 : amp;
        return amp;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
        for (LivingEntity target : list) {
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 600, 0, false, false));
        }
    }
}

