/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.unique;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.entity.SummonedUndeadEntity;
import com.github.dominickwd04.traddon.registry.entities.TrEntities;
import com.github.dominickwd04.traddon.registry.skill.TrSkills;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class NecromancerSkill
extends Skill {
    public static final UUID NECROMANCER = UUID.fromString("1465ec3c-4e31-11ee-be56-0242ac120002");

    public NecromancerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/unique/reaper.png");
    }

    public double getObtainingEpCost() {
        return 50000.0;
    }

    public int getMaxMastery() {
        return 250;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 5000.0;
            case 2 -> 12500.0;
            default -> 1000.0;
        };
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return living instanceof Player && SkillAPI.getSkillsFrom((Entity)living).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(TrSkills.LICH)).map(skill -> !skill.isToggled()).orElse(true) != false;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled() && entity instanceof Player;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_20193_().m_45976_(SummonedUndeadEntity.class, entity.m_20191_().m_82400_(50.0)).size() >= (Integer)TrConfig.INSTANCE.skillsConfig.NecromancerSummonedUndeadMax.get() && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"traddon.skill.necromancer.too_many_undead", (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
            return;
        }
        if (this.getSouls(entity) >= (Integer)TrConfig.INSTANCE.skillsConfig.NecromancerSummonCost.get() * (instance.getMode() == 1 ? 1 : 3)) {
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                this.summonUndead(instance, entity, instance.getMode() == 1 ? 1 : 3);
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"traddon.skill.necromancer.no_souls", (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
        }
        TensuraPlayerCapability.sync((Player)((Player)entity));
    }

    public int modes() {
        return 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return reverse ? (instance.getMode() == 1 ? 2 : 1) : (instance.getMode() == 2 ? 1 : 2);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"traddon.skill.mode.necromancer.summon");
            case 2 -> Component.m_237115_((String)"traddon.skill.mode.necromancer.summon_3");
            default -> Component.m_237119_();
        };
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
            AttributeModifier damageModifier = new AttributeModifier(NECROMANCER, "NecromancerAttack", NecromancerSkill.getAttack(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (damage != null && !damage.m_22109_(damageModifier)) {
                damage.m_22125_(damageModifier);
            }
            AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
            AttributeModifier armorModifier = new AttributeModifier(NECROMANCER, "NecromancerArmor", NecromancerSkill.getArmor(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (armor != null && !armor.m_22109_(armorModifier)) {
                armor.m_22125_(armorModifier);
            }
            AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
            AttributeModifier speedModifier = new AttributeModifier(NECROMANCER, "NecromancerSpeed", NecromancerSkill.getSpeed(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (speed != null && !speed.m_22109_(speedModifier)) {
                speed.m_22125_(speedModifier);
            }
            AttributeInstance shp = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            AttributeModifier shpModifier = new AttributeModifier(NECROMANCER, "NecromancerShp", NecromancerSkill.getShp(this.getSouls(entity)), AttributeModifier.Operation.ADDITION);
            if (shp != null && !shp.m_22109_(shpModifier)) {
                shp.m_22125_(shpModifier);
            }
        }
    }

    public int getSouls(LivingEntity entity) {
        if (entity instanceof Player) {
            return TensuraPlayerCapability.getFrom((Player)((Player)entity)).map(cap -> cap.getSoulPoints() / 1000).orElse(0);
        }
        return 0;
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance shp;
        AttributeInstance armor;
        AttributeInstance speed;
        AttributeInstance damage = entity.m_21051_(Attributes.f_22281_);
        if (damage != null && damage.m_22111_(NECROMANCER) != null) {
            damage.m_22127_(NECROMANCER);
        }
        if ((speed = entity.m_21051_(Attributes.f_22279_)) != null && speed.m_22111_(NECROMANCER) != null) {
            speed.m_22127_(NECROMANCER);
        }
        if ((armor = entity.m_21051_(Attributes.f_22284_)) != null && armor.m_22111_(NECROMANCER) != null) {
            armor.m_22127_(NECROMANCER);
        }
        if ((shp = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())) != null && shp.m_22111_(NECROMANCER) != null) {
            shp.m_22127_(NECROMANCER);
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled() && entity instanceof Player) {
            AttributeInstance shp = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            if (shp.m_22111_(NECROMANCER) != null && shp.m_22111_(NECROMANCER).m_22218_() != NecromancerSkill.getShp(this.getSouls(entity))) {
                instance.onToggleOff(entity);
                instance.onToggleOn(entity);
            }
            for (LivingEntity livingEntity : entity.m_20193_().m_45976_(LivingEntity.class, entity.m_20191_().m_82400_(15.0))) {
                SummonedUndeadEntity undead;
                if (!(livingEntity instanceof SummonedUndeadEntity) || !(undead = (SummonedUndeadEntity)livingEntity).m_21805_().equals(entity.m_20148_()) || !(livingEntity.m_21223_() < livingEntity.m_21233_())) continue;
                livingEntity.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.SELF_REGENERATION.get(), 600, instance.isMastered(entity) ? 1 : 0, false, false), (Entity)entity);
            }
        }
    }

    public void summonUndead(ManasSkillInstance instance, LivingEntity entity, int amount) {
        Level level = entity.m_9236_();
        EntityType skeletonType = (EntityType)TrEntities.SUMMONED_UNDEAD.get();
        for (int i = 0; i < amount; ++i) {
            TensuraPlayerCapability.getFrom((Player)((Player)entity)).ifPresent(cap -> cap.setSoulPoints(cap.getSoulPoints() - this.getSoulCost()));
            SummonedUndeadEntity skeleton = new SummonedUndeadEntity((EntityType<? extends HumanoidNPCEntity>)skeletonType, level);
            skeleton.m_7678_(entity.m_20185_() + (Math.random() - 0.5) * 10.0, entity.m_20186_(), entity.m_20189_() + (Math.random() - 0.5) * 10.0, entity.m_6080_(), 0.0f);
            level.m_7967_((Entity)skeleton);
            skeleton.m_7105_(true);
            skeleton.m_21816_(entity.m_20148_());
            if (instance.isMastered(entity)) {
                TensuraEPCapability.getFrom((LivingEntity)skeleton).ifPresent(cap -> cap.setEP((LivingEntity)skeleton, 8000.0));
                TensuraEPCapability.getFrom((LivingEntity)skeleton).ifPresent(cap -> cap.setCurrentEP(entity, 8000.0));
                AttributeInstance damage = skeleton.m_21051_(Attributes.f_22281_);
                AttributeModifier damageModifier = new AttributeModifier(NECROMANCER, "NecromancerAttack", 8.0, AttributeModifier.Operation.ADDITION);
                if (damage != null && !damage.m_22109_(damageModifier)) {
                    damage.m_22125_(damageModifier);
                }
                AttributeInstance armor = skeleton.m_21051_(Attributes.f_22284_);
                AttributeModifier armorModifier = new AttributeModifier(NECROMANCER, "NecromancerArmor", 8.0, AttributeModifier.Operation.ADDITION);
                if (armor != null && !armor.m_22109_(armorModifier)) {
                    armor.m_22125_(armorModifier);
                }
                AttributeInstance shealth = skeleton.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
                AttributeModifier shealthModifier = new AttributeModifier(NECROMANCER, "NecromancerHealth", 200.0, AttributeModifier.Operation.ADDITION);
                if (shealth != null && !shealth.m_22109_(shealthModifier)) {
                    shealth.m_22125_(shealthModifier);
                }
                AttributeInstance health = skeleton.m_21051_(Attributes.f_22276_);
                AttributeModifier healthModifier = new AttributeModifier(NECROMANCER, "NecromancerHealth", 40.0, AttributeModifier.Operation.ADDITION);
                if (health != null && !health.m_22109_(healthModifier)) {
                    health.m_22125_(healthModifier);
                }
                skeleton.m_21153_(80.0f);
            }
            this.addMasteryPoint(instance, entity);
        }
        if (!instance.isMastered(entity)) {
            instance.setCoolDown(instance.getCoolDown() + 30 * (instance.getMode() == 1 ? 1 : 2));
        } else {
            instance.setCoolDown(instance.getCoolDown() + 15 * (instance.getMode() == 1 ? 1 : 2));
        }
    }

    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        if (instance.isToggled() && instance.isMastered(owner) && e.getEntity() instanceof SummonedUndeadEntity) {
            TensuraPlayerCapability.getFrom((Player)((Player)owner)).ifPresent(cap -> cap.setSoulPoints(cap.getSoulPoints() + (int)((double)this.getSoulCost() * (Double)TrConfig.INSTANCE.skillsConfig.NecromancerSummonedDeathSoulReturn.get())));
            TensuraPlayerCapability.sync((Player)((Player)owner));
            instance.setCoolDown(instance.getCoolDown() - 10);
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int summonAmount = tag.m_128451_("summonAmount");
        if (summonAmount < 5) {
            tag.m_128405_("summonAmount", summonAmount + 1);
        } else {
            tag.m_128405_("summonAmount", 1);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"traddon.skill.summon_amount", (Object[])new Object[]{summonAmount + 1, new Object[0]}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
        }
        instance.markDirty();
    }

    public int getSoulCost() {
        return 1000 * (Integer)TrConfig.INSTANCE.skillsConfig.NecromancerSummonCost.get();
    }

    public static double getArmor(double souls) {
        return souls >= 5000.0 ? 25.0 : souls / 200.0;
    }

    public static double getAttack(double souls) {
        return souls >= 5000.0 ? 20.0 : souls / 250.0;
    }

    public static double getSpeed(double souls) {
        return (souls >= 5000.0 ? 10.0 : souls / 500.0) / 20.0;
    }

    public static double getShp(double souls) {
        return souls >= 5000.0 ? 2500.0 : souls / 2.0;
    }
}

