/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.ability.skill.unique;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SpatialSamuraiSkill
extends Skill {
    public SpatialSamuraiSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("tensura", "textures/skill/unique/severer.png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 5000.0;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public int modes() {
        return 2;
    }

    public double getObtainingEpCost() {
        return 15000.0;
    }

    public double learningCost() {
        return 1000.0;
    }

    public float calculateDamage(LivingEntity entity, ManasSkillInstance instance) {
        return (float)((double)(instance.isMastered(entity) ? ((Double)TrConfig.INSTANCE.skillsConfig.SpatialSamuraiDamageMasterMult.get()).floatValue() : ((Double)TrConfig.INSTANCE.skillsConfig.SpatialSamuraiDamageMult.get()).floatValue()) * entity.m_21133_(Attributes.f_22281_)) + (float)(instance.isMastered(entity) ? 2 : 1) * ((Double)TrConfig.INSTANCE.skillsConfig.SpatialSamuraiDamage.get()).floatValue();
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (this.isInSlot(attacker) && instance.isToggled() && e.getSource().m_7639_() == attacker && DamageSourceHelper.isPhysicalAttack((DamageSource)e.getSource())) {
            LivingEntity target;
            double magiculeCost;
            if (instance.getCoolDown() > 0) {
                return;
            }
            if (instance.getMode() == 1 && !SkillHelper.outOfMagicule((LivingEntity)attacker, (double)(magiculeCost = this.magiculeCost(attacker, instance))) && (target = e.getEntity()) != null) {
                this.addMasteryPoint(instance, attacker);
                instance.setCoolDown(instance.isMastered(attacker) ? 3 : 5);
                TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)DamageSource.m_19370_((LivingEntity)attacker)).setSpatial().setIgnoreBarrier(2.0f).setMpCost(magiculeCost);
                target.m_6469_((DamageSource)source, this.calculateDamage(attacker, instance));
            }
        }
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"traddon.skill.mode.spatial_samurai.imaginary_cleave");
            case 2 -> Component.m_237115_((String)"traddon.skill.mode.spatial_samurai.space_time_slash");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        double magiculeCost = this.magiculeCost(entity, instance);
        if (instance.getMode() == 1) {
            double reach;
            LivingEntity target;
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)magiculeCost) && (target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)(reach = ((Double)TrConfig.INSTANCE.skillsConfig.SpatialSamuraiCleaveRange.get()).doubleValue()), (boolean)false)) != null) {
                TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)DamageSource.m_19370_((LivingEntity)entity)).setSpatial().setIgnoreBarrier(2.0f).setMpCost(magiculeCost);
                target.m_6469_((DamageSource)source, this.calculateDamage(entity, instance));
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
            }
        } else if (instance.getMode() == 2) {
            Level level = entity.m_9236_();
            float radius = ((Double)TrConfig.INSTANCE.skillsConfig.SpatialSamuraiSlashRange.get()).floatValue();
            List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), livingEntity -> !livingEntity.m_7306_((Entity)entity) && livingEntity.m_6084_());
            if (list.isEmpty()) {
                return;
            }
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)(this.magiculeCost(entity, instance) * (double)list.size()))) {
                return;
            }
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
            Iterator var7 = list.iterator();
            LivingEntity target = (LivingEntity)list.get(0);
            while (var7.hasNext()) {
                LivingEntity ent = (LivingEntity)var7.next();
                if (!(ent.m_20182_().m_82554_(entity.m_20182_()) < target.m_20182_().m_82554_(entity.m_20182_()))) continue;
                target = ent;
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            TensuraDamageSource source = DamageSourceHelper.turnTensura((DamageSource)DamageSource.m_19370_((LivingEntity)entity)).setSpatial().setIgnoreBarrier(2.0f).setMpCost(magiculeCost);
            target.m_6469_((DamageSource)source, this.calculateDamage(entity, instance));
        }
    }
}

