/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class TrRacesConfig {
    public final ForgeConfigSpec.BooleanValue abyssCoreEnabled;
    public final ForgeConfigSpec.BooleanValue metalToDark;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> darkSlimeSkills;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> abyssSlimeSkills;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> eldritchSlimeSkills;
    public final ForgeConfigSpec.IntValue UltimateSlimeEvoEP;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> UltimateSlimeSkills;
    public final ForgeConfigSpec.BooleanValue ultimateSlimeEnabled;
    public final ForgeConfigSpec.DoubleValue UltimateSlimeHP;

    public TrRacesConfig(ForgeConfigSpec.Builder builder) {
        builder.push("abyssCoreEnabled");
        this.abyssCoreEnabled = builder.comment("Should the Abyss Core be enabled?").define("enable", true);
        builder.pop();
        builder.push("metalToDark");
        this.metalToDark = builder.comment("Should Metal Slime be able to evolve into Dark Slime?").define("enable", true);
        builder.pop();
        builder.push("darkSlimeSkills");
        this.darkSlimeSkills = builder.comment("Intrinsic skills of Dark Slime").defineList("intrinsicSkills", Arrays.asList("tensura:physical_attack_nullification", "tensura:pain_nullification", "tensura:possession", "tensura:demon_lord_haki"), check -> true);
        builder.pop();
        builder.push("abyssSlimeSkills");
        this.abyssSlimeSkills = builder.comment("Intrinsic skills of Abyss Slime").defineList("intrinsicSkills", Arrays.asList("tensura:infinite_regeneration", "tensura:universal_perception", "tensura:magic_resistance", "tensura:spiritual_attack_resistance", "tensura:darkness_attack_nullification", "traddon:outer_darkness"), check -> true);
        builder.pop();
        builder.push("eldritchSlimeSkills");
        this.eldritchSlimeSkills = builder.comment("Intrinsic skills of Eldritch Slime").defineList("intrinsicSkills", Arrays.asList("tensura:divine_ki_release", "tensura:spiritual_attack_nullification"), check -> true);
        builder.pop();
        builder.push("UltimateSlimeEvoEP");
        this.UltimateSlimeEvoEP = builder.comment("EP required for Ultimate Slime evolution").defineInRange("EP", 10000000, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("UltimateSlimeSkills");
        this.UltimateSlimeSkills = builder.comment("Intrinsic skills of Ultimate Slime").defineList("intrinsicSkills", Arrays.asList("traddon:dragon_spirit_haki"), check -> true);
        builder.pop();
        builder.push("ultimateSlimeEnabled");
        this.ultimateSlimeEnabled = builder.comment("Should Ultimate Slime be enabled?").define("enable", true);
        builder.pop();
        builder.push("UltimateSlimeHP");
        this.UltimateSlimeHP = builder.comment("HP of Ultimate Slime").defineInRange("HP", 6789.0, 0.0, Double.MAX_VALUE);
        builder.pop();
    }
}

