/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class TrSkillsConfig {
    public final ForgeConfigSpec.DoubleValue deviatorChance;
    public final ForgeConfigSpec.DoubleValue deviatorMasterChance;
    public final ForgeConfigSpec.DoubleValue deviatorDamage;
    public final ForgeConfigSpec.DoubleValue deviatorMasterDamage;
    public final ForgeConfigSpec.DoubleValue devastatorKillPercent;
    public final ForgeConfigSpec.DoubleValue devastatorKillPercentResist;
    public final ForgeConfigSpec.DoubleValue devastatorKillPercentNull;
    public final ForgeConfigSpec.DoubleValue devastatorCost;
    public final ForgeConfigSpec.DoubleValue SpatialSamuraiDamage;
    public final ForgeConfigSpec.DoubleValue SpatialSamuraiDamageMult;
    public final ForgeConfigSpec.DoubleValue SpatialSamuraiDamageMasterMult;
    public final ForgeConfigSpec.DoubleValue SpatialSamuraiCleaveRange;
    public final ForgeConfigSpec.DoubleValue SpatialSamuraiSlashRange;
    public final ForgeConfigSpec.DoubleValue outerDarknessRegen;
    public final ForgeConfigSpec.DoubleValue outerDarknessRegenEldritch;
    public final ForgeConfigSpec.DoubleValue outerDarknessBuff;
    public final ForgeConfigSpec.DoubleValue outerDarknessBuffEldritch;
    public final ForgeConfigSpec.IntValue materialCreation;
    public final ForgeConfigSpec.IntValue DragonSpiritHakiDamage;
    public final ForgeConfigSpec.IntValue NecromancerSummonCost;
    public final ForgeConfigSpec.DoubleValue NecromancerSoulGain;
    public final ForgeConfigSpec.DoubleValue NecromancerDeathMPGain;
    public final ForgeConfigSpec.IntValue NecromancerSummonedUndeadMax;
    public final ForgeConfigSpec.DoubleValue NecromancerSummonedDeathSoulReturn;
    public final ForgeConfigSpec.BooleanValue UltimateEnabled;
    public final ForgeConfigSpec.IntValue ReanimationSummonCost;
    public final ForgeConfigSpec.DoubleValue ReanimationSoulGain;
    public final ForgeConfigSpec.DoubleValue ReanimationDeathMPGain;
    public final ForgeConfigSpec.IntValue ReanimationSummonedUndeadMax;
    public final ForgeConfigSpec.DoubleValue ReanimationSummonedDeathSoulReturn;
    public final ForgeConfigSpec.DoubleValue ReanimationDamageMPGain;
    public final ForgeConfigSpec.DoubleValue NecrosisCostIncrease;

    public TrSkillsConfig(ForgeConfigSpec.Builder builder) {
        builder.push("deviator");
        this.deviatorChance = builder.comment("The chance of the Deviator skill taking unique skills.").defineInRange("percent", 0.1, 0.0, 1.0);
        builder.pop();
        builder.push("deviator_master");
        this.deviatorMasterChance = builder.comment("The chance of the Deviator skill taking unique skills with mastery.").defineInRange("percent", 0.2, 0.0, 1.0);
        builder.pop();
        builder.push("deviator_damage");
        this.deviatorDamage = builder.comment("The physical damage to spiritual damage multiplier of the Deviator skill.").defineInRange("multiplier", 1.0, 0.0, 100.0);
        builder.pop();
        builder.push("deviator_master_damage");
        this.deviatorMasterDamage = builder.comment("The physical damage to spiritual damage multiplier of the Deviator skill with mastery.").defineInRange("multiplier", 1.5, 0.0, 100.0);
        builder.pop();
        builder.push("devastator");
        this.devastatorKillPercent = builder.comment("The percent of EP the target should have in relation to user to insta-kill.").defineInRange("percent", 0.75, 0.0, 1.0);
        builder.pop();
        builder.push("devastator_resist");
        this.devastatorKillPercentResist = builder.comment("The percent of EP the target should have in relation to user to insta-kill, while the target has Spiritual Attack Resistance.").defineInRange("percent", 0.5, 0.0, 1.0);
        builder.pop();
        builder.push("devastator_null");
        this.devastatorKillPercentNull = builder.comment("The percent of EP the target should have in relation to user to insta-kill, while the target has Spiritual Attack Nullification.").defineInRange("percent", 0.25, 0.0, 1.0);
        builder.pop();
        builder.push("devastator_cost");
        this.devastatorCost = builder.comment("The EP cost of the Devastator skills Insta-Kill mode. Enter positive value for a percentage based on the targets EP. Enter negative value for a flat cost.(0.0 to 1.0, for percent. -5000, for 5000 magicule cost. 0.0, for no cost)").defineInRange("cost", 0.5, -1.0E8, 1.0);
        builder.pop();
        builder.push("SpatialSamurai");
        this.SpatialSamuraiDamage = builder.comment("The damage of the Spatial Samurai skill.").defineInRange("damage", 100.0, 0.0, 1000000.0);
        builder.pop();
        builder.push("SpatialSamuraiMult");
        this.SpatialSamuraiDamageMult = builder.comment("The damage multiplier of the Spatial Samurai skill.").defineInRange("multiplier", 1.5, 0.0, 100.0);
        builder.pop();
        builder.push("SpatialSamuraiMasterMult");
        this.SpatialSamuraiDamageMasterMult = builder.comment("The damage multiplier of the Spatial Samurai skill with mastery.").defineInRange("multiplier", 2.0, 0.0, 100.0);
        builder.pop();
        builder.push("SpatialSamuraiCleaveRange");
        this.SpatialSamuraiCleaveRange = builder.comment("The range of the Spatial Samurai skill cleave.").defineInRange("range", 32.0, 0.0, 100.0);
        builder.pop();
        builder.push("SpatialSamuraiSlashRange");
        this.SpatialSamuraiSlashRange = builder.comment("The range of the Spatial Samurai skill slash.").defineInRange("range", 20.0, 0.0, 100.0);
        builder.pop();
        builder.push("outer_darkness");
        this.outerDarknessRegen = builder.comment("The amount of EP regenerated while Outer Darkness is active.").defineInRange("percent", 0.01, 0.0, 1.0);
        builder.pop();
        builder.push("outer_darkness_eldritch");
        this.outerDarknessRegenEldritch = builder.comment("The amount of EP regenerated while Outer Darkness is active and the user is an Eldritch Slime.").defineInRange("percent", 0.02, 0.0, 1.0);
        builder.pop();
        builder.push("outer_darkness_buff");
        this.outerDarknessBuff = builder.comment("Damage boost amount for darkness damage while skill is toggled").defineInRange("multiplier", 2.0, 1.0, 100.0);
        builder.pop();
        builder.push("outer_darkness_buff_eldritch");
        this.outerDarknessBuffEldritch = builder.comment("Damage boost amount for darkness damage while skill is toggled and the user is an Eldritch Slime").defineInRange("multiplier", 4.0, 1.0, 100.0);
        builder.pop();
        builder.push("material_creation");
        this.materialCreation = builder.comment("Material creation unlock EP. -1 for disabled.").defineInRange("amount", 10000, -1, 100000000);
        builder.pop();
        builder.push("DragonSpiritHakiDamage");
        this.DragonSpiritHakiDamage = builder.comment("Damage of Dragon Spirit Haki, Enter positive value for a multiplier based on the targets EP. Enter negative value for a flat damage value.(positive, for multiplier. negative, -5000, for 5000 magicule cost.").defineInRange("damage", 50, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
        builder.push("NecromancerSummonCost");
        this.NecromancerSummonCost = builder.comment("The soul cost of summoning a skeleton.)").defineInRange("souls", 50, 1, 1000);
        builder.pop();
        builder.push("NecromancerSoulGain");
        this.NecromancerSoulGain = builder.comment("Soul gain multiplier").defineInRange("multiplier", 3.0, 1.0, 1000.0);
        builder.pop();
        builder.push("NecromancerDeathMPGain");
        this.NecromancerDeathMPGain = builder.comment("The amount of MP gained on death from nearby entities, percent of ep").defineInRange("percent", 0.25, 0.0, 1.0);
        builder.pop();
        builder.push("NecromancerSummonedUndeadMax");
        this.NecromancerSummonedUndeadMax = builder.comment("The maximum number of summoned undead").defineInRange("amount", 15, 0, 1000);
        builder.pop();
        builder.push("NecromancerSummonedDeathSoulReturn");
        this.NecromancerSummonedDeathSoulReturn = builder.comment("The amount of souls returned on death of a summoned undead").defineInRange("percent", 0.5, 0.0, 1.0);
        builder.pop();
        builder.push("UltimateEnabled");
        this.UltimateEnabled = builder.comment("Should the Ultimate skill be enabled?").define("enable", true);
        builder.pop();
        builder.push("ReanimationSummonCost");
        this.ReanimationSummonCost = builder.comment("The soul cost of summoning a skeleton.)").defineInRange("souls", 50, 1, 1000);
        builder.pop();
        builder.push("ReanimationSoulGain");
        this.ReanimationSoulGain = builder.comment("Soul gain multiplier").defineInRange("multiplier", 6.0, 1.0, 1000.0);
        builder.pop();
        builder.push("ReanimationDeathMPGain");
        this.ReanimationDeathMPGain = builder.comment("The amount of MP gained on death from nearby entities, percent of ep").defineInRange("percent", 0.5, 0.0, 1.0);
        builder.pop();
        builder.push("ReanimationSummonedUndeadMax");
        this.ReanimationSummonedUndeadMax = builder.comment("The maximum number of summoned undead").defineInRange("amount", 30, 0, 1000);
        builder.pop();
        builder.push("ReanimationSummonedDeathSoulReturn");
        this.ReanimationSummonedDeathSoulReturn = builder.comment("The amount of souls returned on death of a summoned undead").defineInRange("percent", 1.0, 0.0, 1.0);
        builder.pop();
        builder.push("ReanimationDamageMPGain");
        this.ReanimationDamageMPGain = builder.comment("The amount of MP gained on damage dealt to nearby entities.").defineInRange("damage times:", 100.0, 0.0, 1000000.0);
        builder.pop();
        builder.push("NecrosisCostIncrease");
        this.NecrosisCostIncrease = builder.comment("The amount of cost increase per level of Necrosis").defineInRange("multiplier", 3.0, 1.0, 100.0);
        builder.pop();
    }
}

