/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.entity;

import com.github.dominickwd04.traddon.ability.skill.unique.DevastatorSkill;
import com.github.dominickwd04.traddon.registry.skill.TrSkills;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.human.ShogoTaguchiEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class DevastatorOtherworlderEntity
extends OtherworlderEntity {
    public DevastatorOtherworlderEntity(EntityType<? extends DevastatorOtherworlderEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal((HumanoidNPCEntity)this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new CrossbowAttackGoal((Mob)this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal((HumanoidNPCEntity)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal((HumanoidNPCEntity)this, (PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this, new Class[]{ShogoTaguchiEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, entity -> this.shouldAttackPlayer((LivingEntity)entity)));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/otherworlder/shogo_taguchi.png");
    }

    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)SkillAPI.getSkillRegistry().getValue(TrSkills.DEVASTATOR));
    }

    public void m_6710_(@Nullable LivingEntity pLivingEntity) {
        LivingEntity oldTarget = this.m_5448_();
        super.m_6710_(pLivingEntity);
        LivingEntity newTarget = this.m_5448_();
        ManasSkillInstance instance = this.getDevastator();
        if (instance != null) {
            if (oldTarget == null && newTarget != null) {
                this.activateDevastator();
            } else if (oldTarget != null && newTarget == null) {
                this.activateDevastator();
            }
        }
    }

    private void activateDevastator() {
        double EP = TensuraEPCapability.getEP((LivingEntity)this) * 12.5;
        AttributeInstance armor = Objects.requireNonNull(this.m_21051_(Attributes.f_22284_));
        if (armor.m_22111_(DevastatorSkill.DEVASTATOR) != null) {
            armor.m_22127_(DevastatorSkill.DEVASTATOR);
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            AttributeModifier armorModifier = new AttributeModifier(DevastatorSkill.DEVASTATOR, "DevastatorArmor", DevastatorSkill.getArmor(EP), AttributeModifier.Operation.ADDITION);
            armor.m_22125_(armorModifier);
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.5f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.SOLAR_FLASH.get()), (double)1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_LIGHTNING_EFFECT.get()), (double)3.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_LIGHTNING_EFFECT.get()), (double)2.0);
            TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.PLASMA_FIRE.get()), (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (int)100, (double)0.08, (double)0.08, (double)0.08, (double)0.2, (boolean)true);
        }
        AttributeInstance damage = Objects.requireNonNull(this.m_21051_(Attributes.f_22281_));
        if (damage.m_22111_(DevastatorSkill.DEVASTATOR) != null) {
            damage.m_22127_(DevastatorSkill.DEVASTATOR);
        } else {
            damage.m_22125_(new AttributeModifier(DevastatorSkill.DEVASTATOR, "DevastatorAttack", DevastatorSkill.getAttack(EP) * 1.5, AttributeModifier.Operation.ADDITION));
        }
        AttributeInstance speed = Objects.requireNonNull(this.m_21051_(Attributes.f_22279_));
        if (speed.m_22111_(DevastatorSkill.DEVASTATOR) != null) {
            speed.m_22127_(DevastatorSkill.DEVASTATOR);
        } else {
            speed.m_22125_(new AttributeModifier(DevastatorSkill.DEVASTATOR, "DevastatorSpeed", DevastatorSkill.getSpeed(EP) / 200.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Nullable
    private ManasSkillInstance getDevastator() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(TrSkills.DEVASTATOR));
        if (skill.isEmpty()) {
            return null;
        }
        return !((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this) ? null : (ManasSkillInstance)skill.get();
    }
}

