/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.race;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TrRaceHelper {
    TrRaceHelper() {
    }

    public static boolean evolveRace(Player player) {
        Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (race == null) {
            return false;
        }
        return race.getDefaultEvolution(player) == null ? false : TrRaceHelper.evolveRace(player, race.getDefaultEvolution(player), true);
    }

    public static boolean evolveRace(Player player, Race race, boolean triggerRewards) {
        if (player.m_9236_().m_5776_()) {
            return false;
        }
        Race originalRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (originalRace == null) {
            return false;
        }
        if (!originalRace.getNextEvolutions(player).contains(race) && !race.getPreviousEvolutions(player).contains(originalRace)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TensuraAdvancementsHelper.grant((ServerPlayer)serverPlayer, (ResourceLocation)TensuraAdvancementsHelper.Advancements.GROWTH_SPURT);
        }
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            boolean isMajin = TensuraEPCapability.isMajin((LivingEntity)player);
            cap.setRace((LivingEntity)player, race, false);
            if (isMajin || race.isMajin()) {
                TensuraEPCapability.setMajin((LivingEntity)player, (boolean)true);
            }
            if (triggerRewards) {
                race.triggerEvolutionRewards(player);
            }
            if (!race.getIntrinsicSkills(player).isEmpty()) {
                for (ManasSkill skill : race.getIntrinsicSkills(player)) {
                    if (!SkillUtils.learnSkill((LivingEntity)player, (ManasSkillInstance)new TensuraSkillInstance(skill))) continue;
                    cap.addIntrinsicSkill(skill);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
            }
        });
        TensuraPlayerCapability.sync((Player)player);
        return originalRace != race;
    }

    public static boolean setRace(Player player, Race race) {
        if (player.m_9236_().m_5776_()) {
            return false;
        }
        Race originalRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (originalRace == null || originalRace == race) {
            return false;
        }
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            boolean isMajin = TensuraEPCapability.isMajin((LivingEntity)player);
            cap.setRace((LivingEntity)player, race, false);
            if (isMajin || race.isMajin()) {
                TensuraEPCapability.setMajin((LivingEntity)player, (boolean)true);
            }
            race.triggerEvolutionRewards(player);
            if (!race.getIntrinsicSkills(player).isEmpty()) {
                for (ManasSkill skill : race.getIntrinsicSkills(player)) {
                    if (!SkillUtils.learnSkill((LivingEntity)player, (ManasSkillInstance)new TensuraSkillInstance(skill))) continue;
                    cap.addIntrinsicSkill(skill);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
            }
        });
        TensuraPlayerCapability.sync((Player)player);
        return originalRace != race;
    }
}

