/*
 * Decompiled with CFR 0.152.
 */
package com.github.dominickwd04.traddon.race.slime;

import com.github.dominickwd04.traddon.config.TrConfig;
import com.github.dominickwd04.traddon.race.slime.DarkSlimeRace;
import com.github.dominickwd04.traddon.registry.race.TrRaces;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class AbyssSlimeRace
extends DarkSlimeRace {
    @Override
    public double getBaseHealth() {
        return 1000.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 3.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 8.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.4;
    }

    public float getPlayerSize() {
        return 0.65f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)3.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.2;
    }

    public double getAdditionalSpiritualHealth() {
        return 50.0;
    }

    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)600000.0, (Object)600000.0);
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        return !TensuraPlayerCapability.isTrueDemonLord((Player)player) && !TensuraPlayerCapability.isTrueHero((LivingEntity)player) ? 0.0 : 100.0;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        ((List)TrConfig.INSTANCE.racesConfig.abyssSlimeSkills.get()).forEach(skill -> list.add((TensuraSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill))));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ELDRITCH_SLIME);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ELDRITCH_SLIME);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.ELDRITCH_SLIME));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TrRaces.DARK_SLIME));
        return list;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.awaken_requirement", (Object[])new Object[]{Component.m_237115_((String)"tensura.attribute.true_demon_lord.name").m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237115_((String)"tensura.attribute.true_hero.name").m_130940_(ChatFormatting.GOLD)}));
        return list;
    }

    public boolean isSpiritual() {
        return true;
    }
}

